@section('title')
Authors
@endsection
@extends('admin-layouts.main')
@section('style')

@endsection
@section('rightbar-action')

<a class="btn btn-md btn-success" href="{{url('/admin/create-author')}}"><i class="feather icon-plus mr-1"></i>Create</a>
@endsection


@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-borderless" id="data-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Bio</th>
                                    <th>Profile</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="authors-content">


                            </tbody>
                        </table>
                    </div>

                </div>
                <div class="card-footer pagination ml-3">
                </div>
            </div>
        </div>
        <!-- End col -->

    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
<div class="modal fade " id="create-modal" tabindex="-1" role="dialog" aria-labelledby="create-modal-label" aria-hidden="true">
    <div class="modal-dialog  " role="document">
        <div class="modal-content ">
            <form action="POST" id="create-form" class="" enctype="multipart/form-data">
                <div class="modal-header">
                    <h5 class="modal-title" id="create-modal-label">Create Banner</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="id" value="">
                    <div class="form-group name">
                        <label for="name" class="col-form-label">Name</label>
                        <input type="text" class="form-control" placeholder="Enter Banner Name"
                            id="name"
                            name="name"
                            data-validation="required length"
                            data-validation-length="3-20"
                            data-validation-error-msg="Name is required and it must minimum 3 to 20 charactors." />
                    </div>
                    <div class="form-group priority">
                        <label for="priority" class="col-form-label">Bio</label>
                        <input type="text" class="form-control" placeholder="Enter Banner priority"
                            id="bio"
                            name="bio">
                    </div>
                    <div class="form-group image">
                        <label for="file" class="col-form-label">Image</label><br>
                        <img src="" id="image-view" width="150" height="150" alt="No Image Selected">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="image"
                                id="image"
                                name="image"
                                accept="image/*"
                                onchange="readImage(this);">
                            <label class="custom-file-label" for="customFile">Choose file</label>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary create-submit-btn">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
<!-- Tabledit js -->
<script src="{{ asset('assets/js/admin/authors.js') }}"></script>
@endsection