@section('title')
Create Category
@endsection
@extends('admin-layouts.main')
@section('style')

@endsection

@section('rightbar-action')

<!-- <button class="btn btn-primary-rgba right-action"><i class="feather icon-plus mr-2"></i>Actions</button> -->
@endsection


@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                    </div>
                </div>
                <form method="POST" action="{{route('admin.category.create.p')}}" enctype="multipart/form-data" id="create-form">
                    {{csrf_field()}}
                    <div class="card-body">
                        <input type="hidden" id="id" value="">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Category Name</label>
                                    <input type="text" class="form-control {{ $errors->has('name') ? ' has-error' : '' }}"
                                        name="name"
                                        id="name"
                                        data-validation="required length"
                                        data-validation-length="3-200"
                                        data-validation-error-msg="Name is required &  limit to 3-200 characters."
                                        placeholder="Name"
                                        value="{{old('name')}}" />
                                </div>
                                @if ($errors->has('name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('name') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Parent category</label>
                                    <select class=" form-control" name="parent_id" id="parent_id">
                                        <option value="">Select</option>
                                        @foreach($parent_categories as $category)
                                        <option value="{{ $category->id }}">{{$category->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @if ($errors->has('parent_id'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('parent_id') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Status</label>
                                    <select id="is_active" name="is_active" class="form-control {{ $errors->has('is_active') ? ' has-error' : '' }}">
                                        <option value="1" selected>Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                                @if ($errors->has('is_active'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('is_active') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card m-b-30">
                                    <div class="card-header">
                                        <h5 class="card-title">Category Logo</h5>
                                    </div>
                                    <div class="card-body" id="image-display-div">
                                        <img style="display:none;" id="logo_file" src="#" alt="Restaurant Logo" />
                                    </div>
                                    <div class="card-footer">
                                        <div class="form-group has-feedback">
                                            <input type="file" class="form-control {{ $errors->has('logo') ? ' has-error' : '' }}" name="logo" onchange="readImage(this);">
                                        </div>
                                        @if ($errors->has('logo'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('logo') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card m-b-30">
                                    <div class="card-header">
                                        <h5 class="card-title">Category Banner</h5>
                                    </div>
                                    <div class="card-body" id="image-display-div">
                                        <img style="display:none;" id="banner_file" src="#" alt="Category Banner Image" />
                                    </div>
                                    <div class="card-footer">
                                        <div class="form-group has-feedback">
                                            <input type="file" class="form-control {{ $errors->has('banner') ? ' has-error' : '' }}" name="banner" onchange="readURL(this);">
                                        </div>
                                        @if ($errors->has('banner'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('banner') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


            </div>
            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-6">
                            <button type="submit" class="btn btn-primary create-submit-btn">Save</button>
                        </div>
                    </div>
                </div>
            </div>
            </form>

            <div class="card-footer">
                <div class="row">
                    <div class="col-md-12 pagination"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- End col -->
</div>
<!-- End row -->
</div>


<!-- End Contentbar -->
@endsection
@section('script')
<script>
    function readImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#logo_file')
                    .attr('src', e.target.result)
                    .css('display', 'block')
                    .width(300)
                    .height(200);
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#banner_file')
                    .attr('src', e.target.result)
                    .css('display', 'block')
                    .width(300)
                    .height(200);
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
</script>

@endsection