@section('title') 
Coupon Redeemed Users List
@endsection
@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{url('admin/coupon')}}">List Coupons</a></li>
<li class="breadcrumb-item active" aria-current="page">Coupon Redeemed Users List</li>
@endsection 
@extends('admin-layouts.main')
@section('style')

@endsection 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{$coupon->name}} Redeemed User List</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">

                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>User</th>
                                    <th>Order</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($users->count() > 0)
                                @foreach($users as $user)
                                <tr>
                                    <th>{{$loop->iteration}}</th>
                                    <td>{{$user->user->name}}</td>
                                    <td>{{$user->order->invoice_number}}</td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="3" class="text-center">No User Were Found.</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                 <div class="card-footer pagination ml-3">
                 </div>
                 {{$users->links()}}
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection 
@section('script')

@endsection 