@section('title') 
Cropper
@endsection 
@extends('admin-layouts.main')
@section('style')
<link href="/assets/plugins/cropperjs/cropper.css" rel="stylesheet">
<link href="/assets/plugins/cropperjs/main.css" rel="stylesheet">
@endsection 
 @section('rightbar-action') 

 @endsection 

 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="contentbar">
                <!-- Start row -->
                <div class="row"> 
                    <!-- Start col -->
                    <div class="col-lg-7 col-xl-8">
                        <div class="card m-b-30">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Image Cropping</h5>
                            </div>
                            <div class="card-body">
                                <div class="img-container">
                                  <img src="/assets/images/general/image-crop.jpg" id="image" class="cropper-hidden" alt="Picture">
                                </div>
                            </div>
                        </div>
                        <div class="card m-b-30">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Image Options</h5>
                            </div>
                            <div class="card-body">
                                <div id="docs-buttons" class="docs-buttons">
                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="setDragMode" data-option="move" title="Move">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.setDragMode(&quot;move&quot;)">
                                          <span class="feather icon-move"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="setDragMode" data-option="crop" title="Crop">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.setDragMode(&quot;crop&quot;)">
                                          <span class="feather icon-crop"></span>
                                        </span>
                                      </button>
                                    </div>
                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="zoom" data-option="0.1" title="Zoom In">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.zoom(0.1)">
                                          <span class="feather icon-zoom-in"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="zoom" data-option="-0.1" title="Zoom Out">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.zoom(-0.1)">
                                          <span class="feather icon-zoom-out"></span>
                                        </span>
                                      </button>
                                    </div>
                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="move" data-option="-10" data-second-option="0" title="Move Left">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.move(-10, 0)">
                                          <span class="feather icon-arrow-left"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="move" data-option="10" data-second-option="0" title="Move Right">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.move(10, 0)">
                                          <span class="feather icon-arrow-right"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="move" data-option="0" data-second-option="-10" title="Move Up">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.move(0, -10)">
                                          <span class="feather icon-arrow-up"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="move" data-option="0" data-second-option="10" title="Move Down">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.move(0, 10)">
                                          <span class="feather icon-arrow-down"></span>
                                        </span>
                                      </button>
                                    </div>
                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="rotate" data-option="-45" title="Rotate Left">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.rotate(-45)">
                                          <span class="feather icon-rotate-ccw"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="rotate" data-option="45" title="Rotate Right">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.rotate(45)">
                                          <span class="icon feather icon-rotate-cw"></span>
                                        </span>
                                      </button>
                                    </div>
                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="scaleX" data-option="-1" title="Flip Horizontal">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.scaleX(-1)">
                                          <span class="feather icon-minimize-2"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="scaleY" data-option="-1" title="Flip Vertical">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.scaleY(-1)">
                                          <span class="feather icon-maximize-2"></span>
                                        </span>
                                      </button>
                                    </div>
                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="crop" title="Crop">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.crop()">
                                          <span class="feather icon-check"></span>
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-primary-rgba" data-method="clear" title="Clear">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.clear()">
                                          <span class="feather icon-x"></span>
                                        </span>
                                      </button>
                                    </div>

                                    <div class="btn-group">
                                      <button type="button" class="btn btn-primary-rgba" data-method="reset" title="Reset">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.reset()">
                                          <span class="feather icon-refresh-cw"></span>
                                        </span>
                                      </button>
                                      <label class="btn btn-primary-rgba btn-upload mb-0" for="inputImage" title="Upload image file">
                                        <input type="file" class="sr-only" id="inputImage" name="file" accept="image/*">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="Import image with Blob URLs">
                                          <span class="feather icon-upload"></span> Upload New
                                        </span>
                                      </label>
                                    
                                    </div>
                                    <div class="btn-group btn-group-crop">
                                      <button type="button" class="btn btn-success-rgba" data-method="getCroppedCanvas" data-option="{ &quot;maxWidth&quot;: 4096, &quot;maxHeight&quot;: 4096 }">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.getCroppedCanvas({ maxWidth: 4096, maxHeight: 4096 })">
                                          Download
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-success-rgba" data-method="getCroppedCanvas" data-option="{ &quot;width&quot;: 160, &quot;height&quot;: 90 }">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.getCroppedCanvas({ width: 160, height: 90 })">
                                          160&times;90
                                        </span>
                                      </button>
                                      <button type="button" class="btn btn-success-rgba" data-method="getCroppedCanvas" data-option="{ &quot;width&quot;: 320, &quot;height&quot;: 180 }">
                                        <span class="docs-tooltip" data-toggle="tooltip" title="cropper.getCroppedCanvas({ width: 320, height: 180 })">
                                          320&times;180
                                        </span>
                                      </button>
                                    </div>
                                    <!-- Show the cropped image in modal -->
                                    <div class="modal fade docs-cropped" id="getCroppedCanvasModal" role="dialog" aria-hidden="true" aria-labelledby="getCroppedCanvasTitle" tabindex="-1">
                                      <div class="modal-dialog">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="getCroppedCanvasTitle">Cropped</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                              <span aria-hidden="true">&times;</span>
                                            </button>
                                          </div>
                                          <div class="modal-body"></div>
                                          <div class="modal-footer">
                                            <button type="button" class="btn btn-danger-rgba" data-dismiss="modal">Close</button>
                                            <a class="btn btn-primary-rgba" id="download" href="javascript:void(0);" download="cropped.jpg">Download</a>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  
                                  </div>
                            </div>
                        </div>
                    </div> 
                    <!-- End col -->  
                    <!-- Start col -->
                    <div class="col-lg-5 col-xl-4">
                        <div class="card m-b-30">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Image Preview</h5>
                            </div>
                            <div class="card-body">
                                <div class="docs-preview clearfix">
                                    <div class="img-preview preview-lg"></div>
                                    <div class="img-preview preview-md"></div>
                                    <div class="img-preview preview-sm"></div>
                                    <div class="img-preview preview-xs"></div>
                                </div>
                                <div class="docs-data">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataX">X</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataX" placeholder="x">
                                        <span class="input-group-append">
                                        <span class="input-group-text">px</span>
                                        </span>
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataY">Y</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataY" placeholder="y">
                                        <span class="input-group-append">
                                        <span class="input-group-text">px</span>
                                        </span>
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataWidth">Width</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataWidth" placeholder="width">
                                        <span class="input-group-append">
                                        <span class="input-group-text">px</span>
                                        </span>
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataHeight">Height</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataHeight" placeholder="height">
                                        <span class="input-group-append">
                                        <span class="input-group-text">px</span>
                                        </span>
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataRotate">Rotate</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataRotate" placeholder="rotate">
                                        <span class="input-group-append">
                                        <span class="input-group-text">deg</span>
                                        </span>
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataScaleX">ScaleX</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataScaleX" placeholder="scaleX">
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <label class="input-group-text" for="dataScaleY">ScaleY</label>
                                        </span>
                                        <input type="text" class="form-control" id="dataScaleY" placeholder="scaleY">
                                    </div>
                                </div>    
                            </div>
                        </div>
                        <div class="card m-b-30">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Image Ratio</h5>
                            </div>
                            <div class="card-body">
                                <div id="docs-toggles" class="docs-toggles">
                                    <div class="btn-group d-flex flex-nowrap" data-toggle="buttons">
                                        <label class="btn btn-primary active">
                                            <input type="radio" class="sr-only" id="aspectRatio1" name="aspectRatio" value="1.7777777777777777">
                                            <span class="docs-tooltip" data-toggle="tooltip" title="aspectRatio: 16 / 9">16:9</span>
                                        </label>
                                        <label class="btn btn-primary">
                                            <input type="radio" class="sr-only" id="aspectRatio2" name="aspectRatio" value="1.3333333333333333">
                                            <span class="docs-tooltip" data-toggle="tooltip" title="aspectRatio: 4 / 3">4:3</span>
                                        </label>
                                        <label class="btn btn-primary">
                                            <input type="radio" class="sr-only" id="aspectRatio3" name="aspectRatio" value="1">
                                            <span class="docs-tooltip" data-toggle="tooltip" title="aspectRatio: 1 / 1">1:1</span>
                                        </label>
                                        <label class="btn btn-primary">
                                            <input type="radio" class="sr-only" id="aspectRatio4" name="aspectRatio" value="0.6666666666666666">
                                            <span class="docs-tooltip" data-toggle="tooltip" title="aspectRatio: 2 / 3">2:3</span>
                                        </label>

                                        <label class="btn btn-primary">
                                            <input type="radio" class="sr-only" id="aspectRatio6" name="aspectRatio" value="2">
                                            <span class="docs-tooltip" data-toggle="tooltip" title="aspectRatio: 2 / 1">2:1</span>
                                        </label>
                                        
                                        <label class="btn btn-primary">
                                            <input type="radio" class="sr-only" id="aspectRatio5" name="aspectRatio" value="NaN">
                                            <span class="docs-tooltip" data-toggle="tooltip" title="aspectRatio: NaN">Free</span>
                                        </label>
                                    </div>
                                  
                                  
                                </div>
                            </div>
                        </div>
                    </div>   
                    <!-- End col -->              
                </div>
                <!-- End row -->               
                </div>
                <!-- End row --> 
            </div>
             
            </div>
        </div>
        <!-- End col -->
      
    </div>
    <!-- End row -->
</div>

@include('store.colors.create')          

<!-- End Contentbar -->
@endsection 
@section('script')
<!-- Tabledit js -->
    <script src="/assets/plugins/cropperjs/cropper.js"></script>
    <script src="/assets/plugins/cropperjs/main.js"></script>
    <!-- Core js -->

@endsection 