
@section('title') 
Edit Delivery Partner
@endsection 
@extends('admin-layouts.main')
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                    </div>
                </div>
                <form method="POST" action="{{route('admin.delivery-partner.update', $delivery_partner->id)}}">
                {{csrf_field()}}
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group has-feedback">
                                <label for="name" class="col-form-label">Name</label>
                                <input type="text" class="form-control"   
                                    name="name"
                                    placeholder="Name" 
                                    value="{{ old('name', $delivery_partner->name) }}" />
                            </div>
                            @if ($errors->has('name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('name') }}</strong>
                                </span>
                            @endif
                        </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group has-feedback">
                                    <label for="address" class="col-form-label">Address</label>
                                    <textarea name="address" class="form-control" placeholder="Address" rows="3">{{ old('address', $delivery_partner->address) }}</textarea>
                                </div>
                                @if($errors->has('address'))
                                    <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group has-feedback">
                                    <label for="link" class="col-form-label">Tracking Link (place tracking '[tracking-no]')</label>
                                    <textarea name="link" class="form-control" placeholder="Tracking Link" rows="3">{{ old('link', $delivery_partner->link) }}</textarea>
                                </div>
                                @if($errors->has('link'))
                                    <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('link') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">                                
                        <div class="row align-items-center">
                            <div class="col-6">
                            <button type="submit" class="btn btn-primary create-submit-btn">Update</button>
                            </div>
                        </div>
                    </div>
                </div>
                </form>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection 



