<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<title>Invoice</title>

		<style>
		*{
			margin:0;
		}
			body{
				border: 1px solid #eee;
				background-color: #E0EEEE
			}
			.invoice-box {
				max-width: 800px;
				margin: auto;
				padding: 20px;
				box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
				font-size: 16px;
				line-height: 24px;
				font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
				color: #555;
			}

			.invoice-box table {
				width: 100%;
				line-height: inherit;
				text-align: left;
			}

			.invoice-box table td {
				padding: 5px;
				vertical-align: top;
			}

			.invoice-box table tr td:nth-child(2) {
				text-align: right;
			}


			.invoice-box table tr.top table td.title {
				font-size: 45px;
				line-height: 45px;
				color: #333;
			}
			.invoice-box table tr.heading td {
				background: #00868B;
				color:#fff;
				border-bottom: 1px solid #ddd;
				font-weight: bold;
			}

			.invoice-box table tr.details td {
				padding-bottom: 20px;
			}

			.invoice-box table tr.item td {
				border-bottom: 1px solid #C0C0C0;
			}

			.invoice-box table tr.item.last td {
				border-bottom: none;
			}

			.invoice-box table tr.total td:nth-child(2) {
				font-weight: bold;
			}

			@media only screen and (max-width: 600px) {
				.invoice-box table tr.top table td {
					width: 100%;
					display: block;
					text-align: center;
				}

				.invoice-box table tr.information table td {
					width: 100%;
					display: block;
					text-align: left;
				}
			}

			/** RTL **/
			.rtl {
				direction: rtl;
				font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
			}

			.rtl table {
				text-align: right;
			}

			.rtl table tr td:nth-child(2) {
				text-align: left;
			}
		</style>
	</head>

	<body>
		<div class="invoice-box">
			<table cellpadding="0" cellspacing="0">
				<tr class="top">
					<td colspan="2">
						<table>
							<tr>
								<td class="title">
								<h4>Book At Door</h4>
								</td>

								<td>
									Invoice #<br><strong>{{$order->invoice_number}}</strong><br>
									Order Date <br><strong>{{ Carbon\Carbon::parse($order->created_at)->format('d/m/Y') }}</strong>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr class="information">
					<td colspan="1" style="width: 50%;">
						<table>
							<tr>
								<td>
								<strong>{{ $order->reseller->name }}</strong><br>
								{{ $order->address }}<br>
								Phone : {{ $order->reseller->phone }}
								</td>
							</tr>
						</table>
					</td>
					<td>

					</td>
				</tr>
				
<table>
<thead>
				<tr class="heading">
					<td>#</td>
					<td style="text-align: left;">PRODUCT</td>
					<td>STATUS</td>
					<td>QUANTITY</td>
					<td>PRICE</td>
					<td>TOTAL</td>
				</tr>
				</thead>
				<tbody>
				@foreach($order->products as $key => $product)
				<tr class="item">
				
					<td>{{$key+1}}.</td>
					<td style="text-align: left;">{{ $product->item->name }}</td>
					<td>{{ $product->status->name }}</td>
					<td>{{ $product->quantity }}</td>
					<td>{{ $product->cost }}</td>
					<td>{{ $product->total_cost }}</td>
				</tr>
				@endforeach
				</tbody>
				<tr class="total">
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td>Sub Total : </td>
					<td>{{$order->total_cost}}</td>
				</tr>
				@if($order->shipping_cost > 0)
				<tr class="total">
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td>Delivery Charge : </td>
					<td>{{$order->shipping_cost}}</td>
				</tr>
				@endif
				@if($order->commission > 0)
				<tr class="total">
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td>Commission : </td>
					<td>{{$order->commission}}</td>
				</tr>
				@endif
				<tr class="total">
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td><strong>Grand Total: </strong></td>
					<td><strong>{{$order->grand_total}}</strong></td>
				</tr>
				</table>
			</table>
		</div>
	</body>
</html>