@section('title') 
Order Detail
@endsection 
@extends('admin-layouts.main')
@section('style')

@endsection 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-7 col-xl-8">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-7">
                            <h5 class="card-title mb-0">Order No : #{{$order->invoice_number}}</h5>
                        </div>
                        <div class="col-5 text-right">
                            <span class="badge badge-success-inverse">{{$order->status->name}}</span>                                             
                        </div>
                    </div>
                </div>
                <div class="card-body">                                
                    <div class="row mb-5">
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <div class="order-primary-detail mb-4">
                            <h6>Order Placed</h6>
                            <p class="mb-0">{{ Carbon\Carbon::parse($order->created_at)->format('d-m-Y') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <div class="order-primary-detail mb-4">
                            <h6>Name</h6>
                            <p class="mb-0">{{ $order->reseller->name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <div class="order-primary-detail mb-4">
                            <h6>Email ID</h6>
                            <p class="mb-0">{{ $order->reseller->email }}</p>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <div class="order-primary-detail mb-4">
                            <h6>Contact No</h6>
                            <p class="mb-0">{{ $order->reseller->phone }}</p>
                            </div>
                        </div>
                    </div> 
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-xl-6 ">
                            <div class="order-primary-detail mb-4">
                            <h6>Delivery Address </h6>
                            <p>{{ $order->address }}</p>
                            <!-- <p class="mb-0">+1 123 123 4567</p> -->
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-6 ">
                            <div class="order-primary-detail mb-4">
                            <h6>Payment Type</h6>
                            <p>{{$order->paymentOption->name}}</p>
                            </div>
                        </div>
                    </div>                                
                </div>
            </div> 
            <div class="card m-b-30">
                <div class="card-header">
                    <h5 class="card-title">Order Items</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive ">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <!-- <th scope="col">Action</th>                                                 -->
                                    <!-- <th scope="col">Photo</th> -->
                                    <th scope="col">Product</th>
                                    <th scope="col">Vendor</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Qty</th>
                                    <th scope="col">Price</th>
                                    <th scope="col" class="text-right">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($order->products as $key => $product): ?>
                                    <tr>
                                        <th scope="row">{{$key+1}}</th>
                                        <!-- <td><a href="#" class="text-success mr-2"><i class="feather icon-edit-2"></i></a><a href="#" class="text-danger"><i class="feather icon-trash"></i></a></td> -->
                                        <!-- <td><img src="" class="img-fluid" width="35" alt="product"></td> -->
                                        <td>{{ $product->item->name }}</td>
                                        <td>{{ $product->vendor->name }}</td>
                                        <td>{{ $product->status->name }}</td>
                                        <td>{{ $product->quantity }}</td>
                                        <td>₹{{ $product->cost }}</td>
                                        <td class="text-right">₹{{ $product->total_cost }}</td>
                                    </tr>
                                <?php endforeach ?>
                                
                               
                            </tbody>
                        </table>
                    </div>
                    <div class="row border-top pt-3">
                        <div class="col-md-12 order-2 order-lg-1 col-lg-4 col-xl-6">
                            <div class="order-note">
                                <!-- <p class="mb-5"><span class="badge badge-secondary-inverse">Free Shipping Order</span></p> -->
                                <!-- <h6>Note :</h6> -->
                                <!-- <p>Please, Pack with product air bag and handle with care.</p> -->
                            </div>
                        </div>
                        <div class="col-md-12 order-1 order-lg-2 col-lg-8 col-xl-6">
                            <div class="order-total table-responsive ">
                                <table class="table table-borderless text-right">
                                    <tbody>
                                        <tr>
                                            <td>Sub Total :</td>
                                            <td>₹{{$order->total_cost}}</td>
                                        </tr>
                                        @if($order->shipping_cost > 0)
                                        <tr>
                                            <td>Delivery Charge :</td>
                                            <td>₹{{$order->shipping_cost}}</td>
                                        </tr>
                                        @endif
                                        @if($order->commission > 0)
                                        <tr>
                                            <td>Commission :</td>
                                            <td>₹{{$order->commission}}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <td class="text-black f-w-7 font-18">Amount :</td>
                                            <td class="text-black f-w-7 font-18">₹{{$order->grand_total}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-right">
                   <!--  <button type="button" class="btn btn-primary-rgba my-1"><i class="feather icon-plus mr-2"></i>Add Product</button>
                    <button type="button" class="btn btn-success-rgba my-1"><i class="feather icon-repeat mr-2"></i>Refund</button> -->
                    <!-- <button type="button" class="btn btn-danger-rgba my-1"><i class="feather icon-trash mr-2"></i>Cancel</button> -->
                </div>
            </div>
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-7">
                            <h5 class="card-title mb-0">Invoice PDF Details</h5>
                        </div>
                        <div class="col-5 text-right">
                        <a style="color:white; " href="{{ url('/admin/order-details/'.$order->uid.'/order-details-pdf')}}">
                            <button type="button" class="btn btn-success py-1"><i class="feather icon-download mr-2"></i>Invoice</button>
                            </a> 
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="order-primary-detail">
                        <h6>Current PDF Details</h6>
                        <p class="mb-0">Invoice No : #{{$order->invoice_number}}</p>
                       <!--  <p class="mb-0">Seller GST : 24HY87078641Z0</p>
                        <p class="mb-0">Purchase GST : 24HG9878961Z1</p> -->
                    </div>
                </div>
            </div>                  
        </div>
        <!-- End col -->
        <!-- Start col -->
        <div class="col-lg-5 col-xl-4">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-4">
                            <h5 class="card-title mb-0">Change Status</h5>
                        </div>
                       <!--  <div class="col-8">
                            <div class="card-statistics">
                                <ul class="nav nav-pills mb-0" id="stastic-pills-tab" role="tablist">
                                  <li class="nav-item">
                                    <a class="nav-link active" id="pills-email-tab" data-toggle="pill" href="#pills-email" role="tab" aria-selected="false">Email</a>
                                  </li>
                                  <li class="nav-item">
                                    <a class="nav-link" id="pills-sms-tab" data-toggle="pill" href="#pills-sms" role="tab" aria-selected="false">SMS</a>
                                  </li>
                                </ul>  
                            </div>
                        </div> -->
                    </div>                                
                </div>
                <div class="card-body">
                    <form id="order-status-change-form" action="/store/status-change/{{$order->uid}}" method="POST">
                        <input type="hidden" name="id" value="{{$order->id}}">
                        <div class="form-group">
                            <select class="form-control" name="item_id" required>    
                                <option value="">Select Product</option>                          
                               @foreach($order->products as $key => $product)
                                <option value="{{ $product->item->id }}">{{ $product->item->name }}</option>
                               @endforeach
                            </select>
                        <div class="form-group">
                        </div>
                            <select id="orderCategory" class="form-control" name="order_status_id">
                                <?php foreach ($order_statuses as $key => $status): ?>
                                      <option value="{{$status->id}}"  
                                        @if($status->id == $order->order_status_id)
                                        selected
                                        @endif
                                        >{{$status->name}}</option>
                                <?php endforeach ?>
                            </select>
                        </div>
                       <!--  <div class="form-group">
                            <textarea class="form-control" name="note" id="specialMessage" rows="3" placeholder="Add Special Message"></textarea>
                        </div> -->
                        <button type="submit" class="btn btn-primary"><i class="feather icon-send mr-2"></i>Submit</button>
                    </form>
                </div>
            </div>

    

            </div>
          <!--   <div class="card m-b-30">
                <div class="card-header">
                    <h5 class="card-title">Chat with Customers</h5>
                </div>
                <div class="card-body">
                    <div class="chat-detail order-chat-detail mb-0">
                        <div class="chat-body">
                            <div class="chat-day text-center mb-3">
                                <span class="badge badge-secondary">Today</span>
                            </div>                                
                            <div class="chat-message chat-message-right">
                                <div class="chat-message-text">
                                    <span>Hello!</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:18 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-left">
                                <div class="chat-message-text">
                                    <span>Yes, Sir</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:20 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-right">
                                <div class="chat-message-text">
                                    <span>Schedule demo.</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:25 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-left">
                                <div class="chat-message-text">
                                    <span>Sure, I will.</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:27 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-right">
                                <div class="chat-message-text">
                                    <span>Great. Thanks</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:30 pm<i class="feather icon-clock ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-left">
                                <div class="chat-message-text">
                                    <span>I have completed.</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:20 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-right">
                                <div class="chat-message-text">
                                    <span>Please, send me.</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:25 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-left">
                                <div class="chat-message-text">
                                    <span>Sure, I will email you.</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:27 pm<i class="feather icon-check ml-2"></i></span>
                                </div>
                            </div>
                            <div class="chat-message chat-message-right">
                                <div class="chat-message-text">
                                    <span>Ok, Got it.</span>
                                </div>
                                <div class="chat-message-meta">
                                    <span>4:30 pm<i class="feather icon-clock ml-2"></i></span>
                                </div>
                            </div>
                        </div>
                        <div class="chat-bottom px-0 pb-0">
                            <div class="chat-messagebar">
                                <form>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <button class="btn btn-secondary-rgba" type="button" id="button-addonmic"><i class="feather icon-mic"></i></button>
                                        </div>  
                                        <input type="text" class="form-control" placeholder="Type a message..." aria-label="Text">
                                        <div class="input-group-append">
                                            <button class="btn btn-secondary-rgba" type="submit" id="button-addonlink"><i class="feather icon-link"></i></button>
                                            <button class="btn btn-primary-rgba" type="button" id="button-addonsend"><i class="feather icon-send"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div> -->
           <!--  <div class="card m-b-30">
                <div class="card-header">
                    <h5 class="card-title">Downloads</h5>
                </div>
                <div class="card-body">
                    <p><button type="button" class="btn btn-primary-rgba my-1"><i class="feather icon-file mr-2"></i>Invoice</button></p>
                    <p><button type="button" class="btn btn-info-rgba my-1"><i class="feather icon-box mr-2"></i>Packaing Slip</button></p>
                    <p><button type="button" class="btn btn-success-rgba my-1"><i class="feather icon-gift mr-2"></i>Gift Wrap Detail</button></p>
                </div>
            </div> -->
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection 
@section('script')
<script>
    var notification_popup_flag = false;
</script>
<!-- eCommerce Order Detail Page js -->
<script src="{{ asset('assets/js/custom/custom-ecommerce-order-detail-page.js') }}"></script>
<script src="{{ asset('assets/js/admin/order-details.js') }}"></script>

@endsection   