@section('title')
Create Product Type
@endsection
@extends('admin-layouts.main')
@section('style')

@endsection

@section('rightbar-action')

<!-- <button class="btn btn-primary-rgba right-action"><i class="feather icon-plus mr-2"></i>Actions</button> -->
@endsection


@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                    </div>
                </div>
                <form method="POST" action="{{route('admin.product-type.create.p')}}" enctype="multipart/form-data" id="create-form">
                    {{csrf_field()}}
                    <div class="card-body">
                        <input type="hidden" id="id" value="">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Product Type Name</label>
                                    <input type="text" class="form-control {{ $errors->has('name') ? ' has-error' : '' }}"
                                        name="name"
                                        id="name"
                                        data-validation="required length"
                                        data-validation-length="3-200"
                                        data-validation-error-msg="Name is required &  limit to 3-200 characters."
                                        placeholder="Name"
                                        value="{{old('name')}}" />
                                </div>
                                @if ($errors->has('name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('name') }}</strong>
                                </span>
                                @endif
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Slug</label>
                                    <input type="text" class="form-control {{ $errors->has('name') ? ' has-error' : '' }}"
                                        name="slug"
                                        id="slug"
                                        data-validation="required length"
                                        data-validation-length="3-200"
                                        placeholder="slug"
                                        value="{{old('slug')}}" />
                                </div>
                                @if ($errors->has('slug'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('slug') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                    </div>
            </div>
        </div>


    </div>
    <div class="card m-b-30">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col-6">
                    <button type="submit" class="btn btn-primary create-submit-btn">Save</button>
                </div>
            </div>
        </div>
    </div>
    </form>

    <div class="card-footer">
        <div class="row">
            <div class="col-md-12 pagination"></div>
        </div>
    </div>
</div>
</div>
<!-- End col -->
</div>
<!-- End row -->
</div>


<!-- End Contentbar -->
@endsection
@section('script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const nameInput = document.getElementById('name');
        const slugInput = document.getElementById('slug');
        nameInput.addEventListener('input', function() {
            const slug = generateSlug(nameInput.value);
            slugInput.value = slug;
        });

        function generateSlug(text) {
            return text.toString().toLowerCase()
                .replace(/\s+/g, '-')
                .replace(/[^\w\-]+/g, '')
                .replace(/\-\-+/g, '-')
                .replace(/^-+/, '')
                .replace(/-+$/, '');
        }
    });
</script>
@endsection