@section('title')
    Bulk Upload
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">
        Bulk Upload</li>
@endsection
@extends('admin-layouts.main')
@section('style')
    <link href="/assets/plugins/select2/select2.min.css" rel="stylesheet" type="text/css">
    <style>
        .search_border {
            border: 1px solid black;
            padding: 10px;
            margin: 0px -4px !important;
            border-radius: 11px;
            background: #0a1a52;
            color: #fff !important;
        }

        .search_border label {
            color: #fff;
        }

        .search_button_product {
            width: 100%;
        }

        tr.wrong_data {
            background: #9f2d38 !important;
            border: 1px solid red !important;
        }
        .parent_item{
            color: #2b02f6d4;
            font-weight: bold;
        }
    </style>
@endsection

@section('rightbar-action')
    {{-- <a class="btn btn-md btn-primary" href="{{url('/admin/add-item')}}"><i class="feather icon-plus mr-1"></i>Create</a>
<a class="btn btn-md btn-secondary" href="{{url('/admin/item/download-excel')}}"><i class="feather icon-download mr-1"></i>Export Products</a> --}}
@endsection

@section('rightbar-content')
    <!-- Start Contentbar -->
    <div class="contentbar">
        @if (session('message'))
            <div class="alert  {{ session('message-class') }}" id="successMessage">
                {{ session('message') }}
            </div>
        @endif
        <!-- Start row -->
        <div class="row">
            <!-- Start col -->
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">


                        <div class="row search_border">

                            <div class="col-md-9">
                                <form id="product_search_form" method="POST" action="{{ route('bulkproduct-upload') }}"
                                    enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="form-group">
                                                <label> Bulk upload</label>
                                                <div class='input-group'>
                                                    <input type="file" class="form-control" name="product_list"
                                                        id="product_list" accept=".xlsx, .xls, .csv" />

                                                </div>
                                                <div>
                                                    @if ($errors->has('product_list'))
                                                        <p class="error-tab">
                                                            <strong>*{{ $errors->first('product_list') }}</strong>
                                                        </p>
                                                    @endif
                                                </div>
                                            </div>

                                        </div>

                                        <div class="col-lg-4">
                                            <div class="form-group" style="text-align:start;">
                                                <button type="submit" style="margin-top: 33px;"
                                                    class="btn btn-sm  btn-secondary search-btn search_button_product">upload
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>


                            </div>

                            <div class="col-md-3">
                                @if (isset($products))
                                    <button type="button" data-id="0"
                                        class="edit-button btn btn-sm btn-warning verify_all"
                                        style="float: none; margin-top: 31px;">Verify All</button>
                                @endif
                            </div>


                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-sm">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>SKU</th>
                                        <th>Photo</th>
                                        <th>Title</th>
                                        <th>Price</th>
                                       
                                        <th>Comments</th>
                                        <th>Actions</th>

                                    </tr>
                                </thead>
                                <tbody id="item-content">
                                    @if (isset($products))
                                        @foreach ($products as $key => $product)
                                            <tr class="array_item_{{ $key }}">
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $product['sku'] }} </style></td>
                                                <td><img src="{{ $product['image'] }}" width="50px" height="50px"
                                                        alt=""></td>
                                                <td>{{ $product['title'] }} </style></td>

                                                <td>{{ $product['price'] }}</td>
                                           
                                                <td class="upload_comments"></td>

                                                <td class="cover_action">

                                                    <div class="processing_msg"></div>
                                                    <div class="action_button">
                                                        <div class="btn-group btn-group-sm ">
                                                            <input type="hidden" name="product_data"
                                                                value="{{ json_encode($product) }}">
                                                            <a href="#" data-toggle="tooltip" title=""
                                                                class="tool_tip_cover"
                                                                data-original-title="View Product"><button type="button"
                                                                    data-id="{{ $key }}"
                                                                    class="edit-button btn btn-sm btn-warning view_data"
                                                                    style="float: none; margin: 5px;"><span
                                                                        class="ti-eye"></span></button></a>
                                                            <a href="#" data-toggle="tooltip" title=""
                                                                class="tool_tip_cover"
                                                                data-original-title="Edit Product"><button type="button"
                                                                    data-id="{{ $key }}"
                                                                    class="edit-button btn btn-sm btn-primary edit_data"
                                                                    style="float: none; margin: 5px;"><span
                                                                        class="ti-pencil"></span></button></a>
                                                            <a href="#" data-toggle="tooltip" title="Verify Product"
                                                                class="tool_tip_cover"><button type="button"
                                                                    data-id="{{ $key }}"class="edit-button btn btn-sm btn-success verify_data"
                                                                    style="float: none; margin: 5px;"><span
                                                                        class="ti-check"></span></button></a>
                                                            <button type="button" data-id="{{ $key }}"
                                                                class="delete-button btn btn-sm btn-danger tool_tip_cover delete_data"
                                                                style="float: none; margin: 5px;"><span
                                                                    class="ti-trash"></span></button>
                                                        </div>
                                                    </div>

                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer pagination ml-3">
                    </div>
                </div>
            </div>
            <!-- End col -->
        </div>
        <!-- End row -->
    </div>
    <!-- End Contentbar -->


    <!-- modal -->

    <div class="modal fade" id="view-excel-data" role="dialog">
        <div class="modal-dialog modal-lg">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">View Product</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table  " id="data-table">
                                <thead>
                                    <tr>
                                        <th>Key</th>
                                        <th>Value</th>
                                    </tr>
                                </thead>
                                <tbody id="modal-data-list">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>


    <!-- edit data modal -->
    <div class="modal fade" id="edit-excel-data" role="dialog">
        <div class="modal-dialog modal-lg">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">View Product</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">

                    <div class="card-body">
                        <form action="" id="edit-excel-data" data-row_key="6" method="POST">
                            <div class="table-responsive">
                                <table class="table  " id="data-table">
                                    <thead>
                                        <tr>
                                            <th>Key</th>
                                            <th>Value</th>
                                        </tr>
                                    </thead>
                                    <tbody id="modal-data-edit-list">
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
                </form>
            </div>

        </div>
    </div>

    <!-- modal -->
@endsection
@section('script')
    <!-- Tabledit js -->
    <script src="{{ asset('assets/js/admin/bulk-item.js') }}"></script>
@endsection
