@section('title')
Add Product
@endsection
@extends('admin-layouts.main')
@section('style')
<!-- Summernote css -->
<link href="{{ asset('assets/plugins/summernote/summernote-bs4.css') }}" rel="stylesheet" type="text/css" />
<!-- Dropzone css -->
<link href="/assets/plugins/select2/select2.min.css" rel="stylesheet" type="text/css">
<link href="/assets/css/image-uploader.css" rel="stylesheet" type="text/css">

@endsection
@section('rightbar-action')

@endsection

@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <form action="#" id="create-product-form">
        <div class="row">
            <div class="col-md-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <button class="btn btn-success pull-right" type="submit"><i class="feather icon-plus mr-1"></i>Save Product</button>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <!-- Start col -->
            <div class="col-lg-8 col-xl-9">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Product Detail</h5>
                    </div>
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="col-sm-12">
                                <label for="productTitle" class="col-form-label">Product Name</label>
                                <input type="text" class="form-control font-20" id="productName" placeholder="Name"
                                    name="name"
                                    data-validation="required length"
                                    data-validation-length="3-100"
                                    data-validation-error-msg="Name is required and it must minimum 3 to 100 charactors.">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <label for="productTitle" class="col-form-label">Product SKU</label>
                                <input type="text" class="form-control font-20" id="sku" placeholder="SKU"
                                    name="sku">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Description</label>
                            <div class="col-sm-12">
                                <textarea name="descriptions" class="summernote product_description"></textarea>

                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Specification</label>
                            <div class="col-sm-12">
                                <textarea name="specification" class="summernote"></textarea>

                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Features</label>
                            <div class="col-sm-12">
                                <textarea name="features" class="summernote"></textarea>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Other Detail</h5>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-xl-12">
                        <div class="card m-b-30">
                            <div class="card-body">
                                <div class="tab-content" id="v-pills-product-tabContent">
                                    <div class="tab-pane fade show active" id="v-pills-general" role="tabpanel" aria-labelledby="v-pills-general-tab">



                                        <div class="form-group row ">
                                            <label for="stock" class="col-sm-4 col-form-label">Author</label>
                                            <div class="col-sm-8">
                                                <select class="select2-multi-select form-control" name="author">
                                                    <option value="">Select Author</option>
                                                    @foreach($authors as $author)
                                                    <option value="{{ $author->id }}">{{$author->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row ">
                                            <label for="life_span" class="col-sm-4 col-form-label">Language</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control  {{ $errors->has('language') ? ' has-error' : '' }}"
                                                    name="language"
                                                    id="language" />
                                            </div>
                                        </div>
                                        <div class="form-group row ">
                                            <label for="price" class="col-sm-4 col-form-label">Pages</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control" id="pages" placeholder="123"
                                                    name="pages">
                                            </div>
                                        </div>

                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-xl-12">
                        <div class="card m-b-30">
                            <div class="card-body">
                                <div class="tab-content" id="v-pills-product-tabContent">
                                    <div class="tab-pane fade show active" id="v-pills-general" role="tabpanel" aria-labelledby="v-pills-general-tab">



                                        <div class="form-group row ">
                                            <label for="stock" class="col-sm-4 col-form-label">Stock</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="stock">
                                                    <option value="1">Available</option>
                                                    <option value="0">Out of Stock</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row ">
                                            <label for="life_span" class="col-sm-4 col-form-label">Mrp</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control currency {{ $errors->has('mrp') ? ' has-error' : '' }}"
                                                    name="mrp"
                                                    id="mrp"
                                                    placeholder="0.00" />
                                            </div>
                                        </div>
                                        <div class="form-group row ">
                                            <label for="price" class="col-sm-4 col-form-label">Price</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control currency" id="price" placeholder="0.00"
                                                    name="price"
                                                    data-validation="required"
                                                    data-validation-error-msg="Price is required ">
                                            </div>
                                        </div>
                                        <div class="form-group row ">
                                            <label for="slug" class="col-sm-4 col-form-label">Slug</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control {{ $errors->has('slug') ? ' has-error' : '' }}"
                                                    name="slug"
                                                    id="slug"
                                                    placeholder="" />
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End col -->
            <!-- Start col -->
            <div class="col-lg-4 col-xl-3">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Category</h5>
                    </div>
                    <div class="card-body">
                        <select class="select2-multi-select form-control" name="category_id[]" id="category_id"
                            multiple="multiple"
                            required="required"
                            data-validation="required"
                            data-validation-error-msg="Categories is required ">
                            <option value="">Select</option>

                            @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{$category->name}}</option>

                            @foreach($category->childCategory as $child_category)
                            <option value="{{ $child_category->id }}">-{{$child_category->name}}</option>
                            @endforeach

                            @endforeach

                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Vendor</h5>
                    </div>
                    <div class="card-body">
                        <select class="form-control" name="vendor_id" id="vendor_id">
                            <option value="">Select</option>

                            @foreach($vendors as $vendor)
                            <option value="{{ $vendor->id }}">{{$vendor->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Product Type</h5>
                    </div>
                    <div class="card-body">
                        <select class="select2-multi-select form-control" name="product_type_id[]" id="product_type_id" multiple="multiple">
                            <option value="">Select</option>

                            @foreach($product_types as $product_type)
                            <option value="{{ $product_type->id }}">{{$product_type->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Parent Product</h5>
                    </div>
                    <div class="card-body">
                        <select class="select2-multi-select form-control" name="parent_id" id="parent_id">
                            <option value="">Select</option>
                            @foreach($parent_items as $parent_item)
                            <option value="{{$parent_item->id}}"> {{$parent_item->sku }}{{$parent_item->name}} </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Color</h5>
                    </div>
                    <div class="card-body">
                        <input type="text" class="form-control" name="color" id="item_color" placeholder="Color">
                    </div>
                </div>

                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Size</h5>
                    </div>
                    <div class="card-body">
                        <input type="text" class="form-control" name="size" id="item_size" placeholder="Size">
                    </div>
                </div>


                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Product Image</h5>
                    </div>
                    <div class="card-body" id="image-display-div">
                        <img style="display:none;" id="product_file" src="#" alt="Product Image" />
                    </div>
                    <div class="card-footer">
                        <input type="file" name="product_image" onchange="readImage(this);">
                    </div>
                </div>


            </div>
            <!-- End col -->
        </div>

    </form>
    <!-- End row -->
</div>
<!-- End Contentbar -->




@endsection
@section('script')
<!-- Summernote js -->
<script src="{{ asset('assets/plugins/summernote/summernote-bs4.min.js') }}"></script>
<script src="/assets/plugins/select2/select2.min.js"></script>

<script src="/assets/js/custom/custom-form-select.js"></script>

<!-- Dropzone js -->
<!-- eCommerce Page js -->
<script src="{{ asset('assets/js/custom/custom-ecommerce-product-detail-page.js') }}"></script>
<script src="{{ asset('assets/js/admin/create-product.js') }}"></script>
<script>
    function readImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#product_file')
                    .attr('src', e.target.result)
                    .css('display', 'block')
                    .width(300)
                    .height(200);
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<script>
    document.getElementById('productName').addEventListener('input', function() {
        const productName = this.value;
        const slug = productName
            .toLowerCase()
            .replace(/[^\w\s-]/g, '')
            .trim()
            .replace(/\s+/g, '-')
            .replace(/--+/g, '-');
        document.getElementById('slug').value = slug;
    });
</script>

@endsection