@section('title')
Edit Product
@endsection
@extends('admin-layouts.main')
@section('style')
<!-- Summernote css -->
<link href="{{ asset('assets/plugins/summernote/summernote-bs4.css') }}" rel="stylesheet" type="text/css" />
<!-- Dropzone css -->
<link href="/assets/plugins/select2/select2.min.css" rel="stylesheet" type="text/css">
<link href="/assets/css/image-uploader.css" rel="stylesheet" type="text/css">

@endsection
@section('rightbar-action')

@endsection

@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <form action="#" id="create-product-form">
        <input type="hidden" name="uid" value="{{$product->uid}}">
        <input type="hidden" id="product_svendor_id" value="{{$product->vendor_id}}">
        <div class="row">
            <div class="col-md-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <button class="btn btn-success pull-right" type="submit"><i class="feather icon-plus mr-1"></i>Update</button>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <!-- Start col -->
            <div class="col-lg-8 col-xl-9">
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Product Detail</h5>
                    </div>
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="col-sm-12">
                                <label for="productTitle" class="col-form-label">Product Name</label>
                                <input type="text" class="form-control font-20" id="productName" placeholder="Name"
                                    name="name"
                                    data-validation="required length"
                                    data-validation-length="3-200"
                                    data-validation-error-msg="Name is required and it must minimum 3 to 200 charactors."
                                    value="{{$product->name}}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <label for="productTitle" class="col-form-label">SKU</label>
                                <input type="text" class="form-control font-20" id="sku" placeholder="Name"
                                    name="sku"

                                    value="{{$product->sku}}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Description</label>
                            <div class="col-sm-12">
                                <textarea name="descriptions" class="summernote product_description">{{$product->descriptions}}</textarea>

                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Specifications</label>
                            <div class="col-sm-12">
                                <textarea name="specification" class="summernote">{{$product->specification}}</textarea>

                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-12 col-form-label">Features</label>
                            <div class="col-sm-12">
                                <textarea name="features" class="summernote">{{$product->features}}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Other Detail</h5>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-xl-12">
                        <div class="card m-b-30">
                            <div class="card-body">
                                <div class="tab-content" id="v-pills-product-tabContent">
                                    <div class="tab-pane fade show active" id="v-pills-general" role="tabpanel" aria-labelledby="v-pills-general-tab">

                                        <div class="form-group row mb-3">
                                            <label for="stock" class="col-sm-4 col-form-label">Stock</label>
                                            <div class="col-sm-8">
                                                <select class="form-control" name="stock">
                                                    <option value="1" @if($product->stock == 1) selected @endif>Available</option>
                                                    <option value="0" @if($product->stock == 0) selected @endif>Out of Stock</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row ">
                                            <label for="mrp" class="col-sm-4 col-form-label">MRP</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control currency {{ $errors->has('life_span') ? ' has-error' : '' }}"
                                                    name="mrp"
                                                    id="mrp"
                                                    placeholder="0.00"
                                                    value="{{$product->mrp}}" />
                                            </div>
                                        </div>
                                        <div class="form-group row mb-3">
                                            <label for="price" class="col-sm-4 col-form-label">Price($)</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control currency" id="price" placeholder="0.00"
                                                    name="price"
                                                    data-validation="required"
                                                    data-validation-error-msg="price is required "
                                                    value="{{$product->price}}">
                                            </div>
                                        </div>

                                        <div class="form-group row ">
                                            <label for="slug" class="col-sm-4 col-form-label">Slug</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control {{ $errors->has('slug') ? ' has-error' : '' }}"
                                                    name="slug"
                                                    id="slug"
                                                    value="{{$product->slug}}"
                                                    placeholder="" />
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End col -->
            <!-- Start col -->
            <div class="col-lg-4 col-xl-3">

                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Categories</h5>
                    </div>
                    <div class="card-body">
                        <select class="select2-multi-select form-control" name="category_id[]" id="category_id"
                            multiple="multiple"
                            required="required"
                            data-validation="required"
                            data-validation-error-msg="Categories is required ">
                            @if($selected_categories->count() > 0)
                            @foreach($selected_categories as $selected_category)
                            <option value="{{ $selected_category->category_id }}" selected="true">{{ $selected_category->category_name  }}</option>
                            @endforeach
                            @endif
                            @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @foreach($category->childCategory as $child_category)
                            <option value="{{ $child_category->id }}">-{{$child_category->name}}</option>
                            @endforeach
                            @endforeach

                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Vendor</h5>
                    </div>
                    <div class="card-body">
                        <select class="form-control" name="vendor_id" id="vendor_id">
                            <option value="">Select</option>
                            @foreach($vendors as $vendor)
                            <option @if($product->vendor_id == $vendor->id) selected @endif
                                value="{{ $vendor->id }}">{{$vendor->name}}</option>
                            @endforeach

                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Product Type</h5>
                    </div>
                    <div class="card-body">
                        <select class="select2-multi-select form-control" name="product_type_id[]" id="product_type_id" multiple="multiple">
                            @if($selected_product_types->count() > 0)
                            @foreach($selected_product_types as $selected_product_type)
                            <option value="{{ $selected_product_type->product_type_id }}" selected="true">{{ $selected_product_type->product_type_name  }}</option>
                            @endforeach
                            @endif
                            @foreach($product_types as $product_type)
                            <option value="{{ $product_type->id }}">{{ $product_type->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Parent Product</h5>
                    </div>
                    <div class="card-body">
                        <select class="select2-multi-select form-control" name="parent_id" id="parent_id">
                            <option value="">Select</option>

                            @foreach($parent_items as $parent_item)
                            <option value="{{ $parent_item->id }}" @if($parent_item->id == $product->parent_id)selected @endif>{{$parent_item->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Color</h5>
                    </div>
                    <div class="card-body">
                        <input type="text" class="form-control" name="color" id="item_color" placeholder="Color" value="{{ $product->color }}">
                    </div>
                </div>

                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Size</h5>
                    </div>
                    <div class="card-body">
                        <input type="text" class="form-control" name="size" id="item_size" placeholder="Size" value="{{ $product->size }}">
                    </div>
                </div>

                <div class="card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title">Product Image</h5>
                    </div>
                    <div class="card-body" id="image-display-div">
                        <div class="d-inline-block ml-1 mb-1 selected_image_container">
                            <img id="product_file" src="{{$product->image}}" alt="Product Image" class="img-fluid rounded">
                        </div>
                    </div>
                    <div class="card-footer">
                        <input type="file" name="product_image" onchange="readImage(this);">
                    </div>
                </div>

            </div>
            <!-- End col -->
        </div>

    </form>
    <!-- End row -->
</div>
<!-- End Contentbar -->

<!-- Modal -->
<div class="modal fade" id="image_upload_modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog slideInRight animated modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="image_upload_modal_title">Add Product Image</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row" id="folder_div">
                    <div class="col-md-12">
                        <div class="stage">
                            <div class="folder-wrap level-current scrolling" id="folder_content">

                            </div><!-- .folder-wrap -->
                        </div><!-- .stage -->
                    </div>
                    <div class="col-md-12 folder-pagination">

                    </div>
                </div>
                <div class="row" id="image_div">
                    <div class="col-md-12">
                        <div class="gallery-item-box">
                            <div class="gallery-item-box">
                                <div class="grid row justify-content-md-center" id="image_content">



                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 image-pagination">

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" data-dismiss="modal">Choose</button>
            </div>
        </div>
    </div>
</div>


@endsection
@section('script')
<!-- Summernote js -->
<script src="{{ asset('assets/plugins/summernote/summernote-bs4.min.js') }}"></script>
<script src="/assets/plugins/select2/select2.min.js"></script>

<script src="/assets/js/custom/custom-form-select.js"></script>

<!-- Dropzone js -->
<!-- eCommerce Page js -->
<script src="{{ asset('assets/js/custom/custom-ecommerce-product-detail-page.js') }}"></script>
<script src="{{ asset('assets/js/admin/edit-product.js') }}"></script>
<script>
    function readImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#product_file')
                    .attr('src', e.target.result)
                    .width(350)
                    .height(200);
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<script>
    $(document).ready(function() {
        var values = $('#product_tags').val();
        if (values.includes("5")) {
            $('#offer_div').css('display', 'block');
        }
        if (values.includes("6")) {
            $('#pre_order_div').css('display', 'block');
        }
    });
</script>
<script>
    function getTag() {
        var values = $('#product_tags').val();
        if (values.includes("5")) {
            $('#offer_div').css('display', 'block');
        }
        if (values.includes("6")) {
            $('#pre_order_div').css('display', 'block');
        }
        if (!values.includes("5")) {
            $('#offer_div').css('display', 'none');
        }
        if (!values.includes("6")) {
            $('#pre_order_div').css('display', 'none');
        }
    }
</script>
@endsection