@section('title') 
Product Delivery Charges
@endsection 
@extends('admin-layouts.main')
@section('style')
<!-- Dropzone css -->
<link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/image-uploader.css') }}" rel="stylesheet" type="text/css">
@endsection 

@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">
@if(Session::has('message'))
    <div class="pad margin no-print">
      <div  style="background-color:#28a745; padding:20px; margin-bottom: 0!important;">
          <div class="text-white">{{ Session::get('message') }} </div> 
      </div>
    </div>
    <br>
    @endif               
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Add Product Delivery Charge</h5>
                        </div>
                    </div>
                </div>
                <form method="POST" action="{{route('admin.product.delivery.charge.create',$item->id)}}" enctype="multipart/form-data">
                {{csrf_field()}}
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">State</label>
                                <select  name="state_id[]" class="select2-multi-select form-control {{ $errors->has('state_id') ? ' has-error' : '' }} "  multiple="multiple">
                                    <option value="">Select</option>
                                    @foreach ($states as $state)
                                        <option value="{{ $state->id }}">{{ $state->name }}</option>
                                    @endforeach
                                </select>
                            </div>  
                            @if ($errors->has('state_id'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('state_id') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="delivery_charge" class="col-form-label">Delivery Charge</label>
                                <input type="text" class="form-control currency" placeholder="0.00"
                                name ="delivery_charge" 
                                value="{{old('delivery_charge')}}"
                                >
                            </div>  
                            @if ($errors->has('delivery_charge'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('delivery_charge') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    </div>
                </div>
                <div class="card m-b-30">
                    <div class="card-header">                                
                        <div class="row align-items-center">
                            <div class="col-6">
                            <button type="submit" class="btn btn-primary">Add</button>
                            </div>
                        </div>
                    </div>
                </div>
                </form>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    <div>
</div>
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Product Delivery Charge List</h5>
                            <input type="hidden" id="id" name="id" value="{{$item->id}}">
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>State</th>
                                    <th>Delivery Charge</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="delivery-content">
                              
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
@include('admin.products.product-delivery-charge-edit')  
<!-- End Contentbar -->
@endsection 
@section('script')
<script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script>    
<script src="{{ asset('assets/js/custom/custom-form-select.js') }}"></script>

<script src="{{ asset('assets/js/admin/delivery-charge.js') }}"></script>
@endsection 