@section('title')
Product Variant
@endsection

@extends('admin-layouts.main')
@section('style')

@endsection

@section('rightbar-action')

@endsection

@section('rightbar-content')
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Ratings & Reviews</h5>
                        </div>
                        <div class="col-6">
                            <ul class="list-inline-group text-right mb-0 pl-0">
                                <li class="list-inline-item">
                                    <div class="form-group mb-0 amount-spent-select">
                                        <input type="text" id="search" class="form-control" placeholder="Search">
                                        <input type="hidden" id="id" name="id" value="{{$item->id}}">
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>SKU</th>
                                    <th>Photo</th>
                                    <th>Name</th>
                                    <th>Price</th>
                                    <th>Stock Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($variants as $product)
                                <tr scope="row">
                                    <td>{{$loop->iteration}}</td>
                                    <td>{{$product->sku}}</td>
                                    <td><img src="{{$product->image}}" alt="" class="img-fluid" width="35"></td>
                                    <td class="limited-text" title="{{ $product->name }}">{{ Str::limit($product->name, 50) }} </td>
                                    <td>₹{{ number_format($product->price, 2) }}</td>
                                    <td>
                                        @if($product->stock == 1)
                                        <span class="badge badge-success">Available</span>
                                        @else
                                        <span class="badge badge-danger">Out of Stock</span>
                                        @endif
                                    </td>

                                    <!-- Action Buttons -->
                                    <td>
                                        <div class="button-list">
                                            <!-- Edit Product Button -->
                                            <a href="{{ url('/admin/edit-product/' . $product->uid) }}" class="btn btn-warning-rgba">
                                                <i class="feather icon-edit-2"></i>
                                            </a>


                                            <a href="{{ url('/admin/' . base64_encode($product->id) . '/gallery-list') }}" class="btn btn-info-rgba">
                                                <i class="feather icon-image"></i>
                                            </a>


                                            <button type="button" data-id="{{ $product->id }}" class="delete-button btn btn-danger-rgba">
                                                <i class="feather icon-trash-2"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                            <tbody id="product-content">

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection
@section('script')
<script src="{{ asset('assets/js/admin/review.js') }}"></script>
@endsection