@section('title') 
Ratings & Reviews
@endsection

@extends('admin-layouts.main')
@section('style')

@endsection 

 @section('rightbar-action') 
 <div class="table-responsive">
    <table class="table table-borderless">
        <tr>
            <th class="text-right">Total Review</th>
            <td class="text-left">{{$total_review}}</td>
        </tr>
        <tr>
            <th class="text-right">Average Rating</th>
            <td class="text-left">{{$total_rating}}</td>
        </tr>
    </table>
</div>
@endsection 

@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Ratings & Reviews</h5>
                        </div>
                        <div class="col-6">
                            <ul class="list-inline-group text-right mb-0 pl-0">
                                 <li class="list-inline-item">
                                      <div class="form-group mb-0 amount-spent-select">
                                        <input type="text" id="search" class="form-control" placeholder="Search">
                                        <input type="hidden" id="id" name="id" value="{{$item->id}}">
                                    </div>
                                </li>
                            </ul>                                        
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless" style="width:100%;white-space:nowrap;table-layout:fixed">
                            <thead>
                                <tr>
                                    <th>Reseller Name</th>
                                    <th>Rating</th>
                                    <th>Review</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="review-content">
                              
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection 
@section('script')
<script src="{{ asset('assets/js/admin/review.js') }}"></script>
@endsection 