@section('title') 
View Product Details
@endsection 
@extends('admin-layouts.main')
@section('style')

@endsection 

@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">      
<div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Product Details</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Price</th>
                                    <th>Leaf Number</th>
                                    <th>Stock Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{$product->name}}</td>
                                    <td>{{$product->price}}</td>
                                    <td>{{$product->leaf_number}}</td>
                                    <td>
                                        {!! ($product->stock == 1) ? '<span class="badge badge-success">Available</span>' : '<span class="badge badge-danger">Out of Stock</span>' !!}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    <div>
</div>
<div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Vendor Details</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Vendor</th>
                                    <th>Address</th>
                                    <th>Phone</th>
                                    <th>email</th>
                                    <th>Pincode</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{$product->vendor->name}}</td>
                                    <td>{{$product->vendor->address}}</td>
                                    <td>{{$product->vendor->phone}}</td>
                                    <td>{{$product->vendor->email}}</td>
                                    <td>{{$product->vendor->pincode}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    <div>
</div>
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Delivery Charge List</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>State</th>
                                    <th>Delivery Charge</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($product->product_delivery_charge->count() > 0)
                                @foreach($product->product_delivery_charge as $product_delivery_charge)
                                <tr>
                                    <td>{{$product_delivery_charge->state->name}}</td>
                                    <td>{{$product_delivery_charge->delivery_charge}}</td>
                                </tr>
                                @endforeach
                                @else
                                <tr class="text-center">
                                    <td colspan="2"> No Data Found.</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    <div>
</div>
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Gallery</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Image</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($product->item_image->count() > 0)
                                @foreach($product->item_image as $item)
                                <tr>
                                    <td>{{$item->name}}</td>
                                    <td><img src="{{$item->image}}" class="img-fluid" width="60" alt="product"></td>
                                    
                                </tr>
                                @endforeach
                                @else
                                <tr class="text-center">
                                    <td colspan="2">No Data Found.</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
    <div class="card m-b-30">
        <div class="card-header">                                
            <div class="row align-items-center">
                <div class="col-6">
                <form method="POST" action="{{route('admin.verify.product',$product->id)}}">
                {{csrf_field()}}
                    <button type="submit" class="btn btn-success">Approve</button>
                </form>
                </div>
            </div>
        </div>
    </div>
@include('admin.products.product-delivery-charge-edit')  
<!-- End Contentbar -->
@endsection 
@section('script')

@endsection 