@section('title') 
Create Push Notification
@endsection
@section('breadcrumb')
<li class="breadcrumb-item active" aria-current="page">Add Notification</li>
@endsection 
@extends('admin-layouts.main')
@section('style')

@endsection 

 @section('rightbar-action') 

 <!-- <button class="btn btn-primary-rgba right-action"><i class="feather icon-plus mr-2"></i>Actions</button> -->
 @endsection 

 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                    </div>
                </div>
                <form method="POST" action="{{route('admin.push-notification.create.p')}}" enctype="multipart/form-data" id="create-form" >
                {{csrf_field()}}
                <div class="card-body">
                    <div class="form-group has-feedback">
                        <label for="title" class="col-form-label">Title</label>
                        <input type="text" class="form-control {{ $errors->has('title') ? ' has-error' : '' }}"   
                            name="title"
                            id="title"
                            placeholder="Title" 
                            value="{{old('title')}}"
                            required
                           />
                    </div>
                    @if ($errors->has('title'))
                        <span class="help-block">
                            <strong class="error-text">{{ $errors->first('title') }}</strong>
                        </span>
                    @endif
                    <div class="form-group has-feedback">
                        <label for="description" class="col-form-label">Description</label>
                        <textarea name="description" id="description" class="form-control {{ $errors->has('description') ? ' has-error' : '' }}" placeholder="Description"  rows="3"  required>{{old('description')}}</textarea>
                    </div>
                    @if ($errors->has('description'))
                        <span class="help-block">
                        <strong class="error-text">{{ $errors->first('description') }}</strong>
                        </span>
                    @endif
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card m-b-30">
                                <div class="card-header">
                                    <h5 class="card-title">Image</h5>
                                </div>
                                <div class="card-body" id="image-display-div">   
                                    <img style="display:none;" id="image" src="#" alt="Image" />                          
                                </div>
                                <div class="card-footer">
                                <div class="form-group has-feedback">
                                    <input type="file" class="form-control {{ $errors->has('image') ? ' has-error' : '' }}" name="image" onchange="readImage(this);"  required>
                                </div>
                                @if ($errors->has('image'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('image') }}</strong>
                                        </span>
                                @endif
                                </div>
                            </div>
                        </div>
                       </div> 
                    </div>
                  

                </div>
                <div class="card m-b-30">
                    <div class="card-header">                                
                        <div class="row align-items-center">
                            <div class="col-6">
                            <button type="submit" class="btn btn-primary create-submit-btn">Create</button>
                            </div>
                        </div>
                    </div>
                </div>
                </form>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
          

<!-- End Contentbar -->
@endsection 
@section('script')
<script>
        function readImage(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#image')
                        .attr('src', e.target.result)
                        .css('display','block')
                        .width(300)
                        .height(200);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
</script>
@endsection 





