@section('title') 
Notification Users List
@endsection
@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{url('admin/push-notification')}}">List Notifications</a></li>
<li class="breadcrumb-item active" aria-current="page">Notification Users List</li>
@endsection 
@extends('admin-layouts.main')
@section('style')
<style>
table.table td{
    color:black;
}
table.table th{
    color:white;
}
table.table thead{
    background-color:#4f8339;
}
table.table tbody tr:nth-child(odd){
  background-color: rgb(79, 131, 57,0.3);
}
</style>
@endsection 
 @section('rightbar-action') 
 @endsection 

 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
            <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Notification Users List</h5>
                        </div>
                        <div class="col-6">
                            <ul class="list-inline-group text-right mb-0 pl-0">
                                 <li class="list-inline-item">
                                      <div class="form-group mb-0 amount-spent-select">
                                        
                                    </div>
                                </li>
                            </ul>                                        
                        </div>
                    </div>
                </div>
                <div class="card-body">
                <div class="table-responsive">
                        <table class="table  table-striped">
                            <thead>
                                <tr>
                                    <th scope="col">Sl.No</th>
                                    <th scope="col">user</th>
                                    <th>phone</th>
                                    <th>delivered time</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if(!count($users))
                                <tr>
                                    <td colspan="4" class="text-center">Data not found.</td>
                                </tr>
                             @else
                                @foreach($users as $user)
                                <tr>
                                    <th style="color:black;">{{$loop->iteration}}</th>
                                    <td>{{$user->user->name}}</td>
                                    <td>{{$user->user->phone}}</td>
                                    <td>{{$user->created_at}}</td>
                                </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>

                </div>
                 <div class="card-footer pagination ml-3">
                 </div>
            </div>
        </div>
        <!-- End col -->
      
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->        

@endsection 
@section('script')
<!-- Tabledit js -->

@endsection 