<html>
    <head>
    <style>
        /** 
            Set the margins of the page to 0, so the footer and the header
            can be of the full height and width !
            **/
        @page {
            margin: 0cm 0cm;
        }

    

        /** Define the header rules **/
        header {
            position: fixed;
            top: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            /** Extra personal styles **/
            background-color: #4F7942;
            color: white;
            text-align: center;
            line-height: .5cm;
        }

        /** Define the footer rules **/
        footer {
            position: fixed; 
            bottom: 0cm; 
            left: 0cm; 
            right: 0cm;
            height: 2cm;

            /** Extra personal styles **/
            background-color: #fff;
            color: #000;
            line-height: .5cm;
        }
            /** Define now the real margins of every page in the PDF **/
        body {
            margin-top: 2.5cm;
            margin-left: 0.5cm;
            margin-right: 0.5cm;
            margin-bottom:2.5cm;
        }
        table.heading_table {
            width: 100%;
            height: 76px;
            border: none;
        }
        
        table.heading_table td {
            border: none !important;
        }
        table{
            border:1px solid black;
        }
        #column:nth-of-type(odd) {
            background-color: #ececec;
            width:20px;
        }
        thead{
            border-bottom:1px solid black;
            background-color: white;
        }
        h3{
            font-family:Helvetica;
            font-size:18px;
            text-align:center;
        }
        th{
            font-family:Helvetica;
            font-size:13px;
        }
        td#date_field {
            width: 80px;
            }
        td{
            font-family:Helvetica;
            font-size:12px;
        }
        tr{
            text-align:center;
        }
        p{
            font-family:Helvetica;
            font-size:14px;
        }
        table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
        }
        td#header_logo img {
         width: 113px;
        height: 72px;
        }
        .heading_table {
         color: #fff;
        }
        td#header_logo {
         width: 33%;
        }

    </style>
    </head>
    <header>
            <table class="heading_table" border="0">
                <tr>
                    <td id="header_logo">
                        <h3>Book At Door</h3>
                        
                    </td>
                    <td style="line-height: 2px;"> <h3><i>Reseller Sales Report</i></h3>
                            @if($reseller != null)
                            <p style="text-align: center;"><i>reseller :</b> {{$reseller['name']}}</i></p>
                            @endif  
                    </td>
                    <td style="text-align: right;padding-right: 0.5cm;">
                        From Date :</b> {{date('d F Y', strtotime($from))}} <br>
                        To Date :</b> {{date('d F Y', strtotime($to))}}<br>
                       
                    </td>
                </tr>
            </table>
        </header>

        <footer>
        <p style="text-align:right; margin-right:.5cm">
         Book At Door<br>
        Generated at &copy; <?php echo date("d-m-Y H:i:s");?> </p>
        </footer>
    
        <body>

                   <table width="100%">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Date</th>
                                    <th>order</th>
                                    <th>Grand Total</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if (!count($orders))
                                <tr>
                                    <td colspan="3" class="text-center">Data not found.</td>
                                </tr>
                            @else
                            @foreach($orders as $order)
                                <tr>
                                    <td>{{$loop->iteration}}</td>
                                    <td>{{date('d-m-Y', strtotime($order->created_at))}}</td>
                                    <td>{{$order->order->invoice_number}}</td>
                                    <td>{{$order->total_cost}}</td>
                                </tr>
                                @endforeach
                            @endif
                            </tbody>
                </table>    
        </body>

</html>