
@section('title') 
Reseller Sales Report
@endsection 
@extends('admin-layouts.main')
@section('style')

@endsection 
@section('rightbar-action')

@endsection
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <form action="{{route('admin.reseller-sales-report')}}" method="GET">
                    {{csrf_field()}}
                        <div class="row">
                        <div class="col-lg-3 col-md-3"> 
                                <div class="form-group">                     
                                  <label> Reseller</label>
                                  <select required class="form-control" onkeydown="return false" id="reseller" name="reseller"  value="{{$reseller}}"  autocomplete="off" required>
                                    <option  value="">Select Reseller</option>
                                    @foreach ($resellers as $reseller_item)
                                    <option  value="{{ $reseller_item->id }}" @if($reseller_item->id == $reseller )selected @endif>{{ $reseller_item->name }}</option>
                                    @endforeach
                                  </select>
                                </div>
                              </div>
                            <div class="col-md-2"> 
                                <div class="form-group">   
                                    <label> From Date</label>
                                    <div class='input-group date'>
                                    <input type="text" class="form-control datepicker1"  id="fromDate" name="from_date" value="{{$from_date}}"  autocomplete="off" aria-describedby="basic-addon5" required>
                                </div>
                                </div>
                            </div>
                            <div class="col-md-2"> 
                                <div class="form-group">                     
                                    <label> To Date</label>
                                    <div class='input-group date'>
                                    <input type="text" class="form-control datepicker2" id="toDate" name="to_date"  value="{{$to_date}}"  autocomplete="off" aria-describedby="basic-addon5" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">  
                            <div class="form-group" style="text-align:start;">                           
                                <button type="submit" style="margin-top: 33px;" class="btn btn-sm btn-primary search-btn " > <i class="fa fa-search"></i> </button>
                                <?php if($orders && count($orders) > 0){?> 
                                    <a style="color:white; " href="{{ route('admin.reseller-sales-report-pdf',['reseller'=> $reseller, 'from_date'=>$from_date , 'to_date' => $to_date])}}">
                                            <button type="button" style="margin-top: 33px;" class="btn btn-primary ">Export PDF</button> 
                                        </a>  
                                <?php } ?>   
                            </div>
                            </div>
                        </div>
                    </form> 
                </div>
            </div>
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Reseller Sales Report</h5>
                        </div>
                        <div class="col-6">
                            <ul class="list-inline-group text-right mb-0 pl-0">
                                 <li class="list-inline-item">
                                </li>
                            </ul>                          
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>order</th>
                                    <th>Grand Total</th>
                                                                            
                                </tr>
                            </thead>
                            <tbody>
                            @if (!count($orders))
                                <tr>
                                    <td colspan="3" class="text-center">Data not found.</td>
                                </tr>
                            @else
                            @foreach($orders as $order)
                                <tr>
                                    <td>{{date('d-m-Y', strtotime($order->created_at))}}</td>
                                    <td>{{$order->order->invoice_number}}</td>
                                    <td>{{$order->total_cost}}</td>
                                </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                 <div class="card-footer pagination ml-3">
                 </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection 
@section('script')

@endsection 