
@section('title') 
Vendor Sales Report
@endsection 
@extends('admin-layouts.main')
@section('style')

@endsection 
@section('rightbar-action')

@endsection
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">
                    <form action="{{route('admin.sales-report')}}" method="GET">
                    {{csrf_field()}}
                        <div class="row">
                        <div class="col-lg-3 col-md-3"> 
                                <div class="form-group">                     
                                  <label> Vendor</label>
                                  <select required class="form-control" onkeydown="return false" id="vendor" name="vendor"  value="{{$vendor}}"  autocomplete="off" required>
                                    <option  value="">Select Vendor</option>
                                    @foreach ($vendors as $vendor_item)
                                    <option  value="{{ $vendor_item->id }}" @if($vendor_item->id == $vendor )selected @endif>{{ $vendor_item->name }}</option>
                                    @endforeach
                                  </select>
                                </div>
                              </div>
                            <div class="col-md-2"> 
                                <div class="form-group">   
                                    <label> From Date</label>
                                    <div class='input-group date'>
                                    <input type="text" class="form-control datepicker1"  id="fromDate" name="from_date" value="{{$from_date}}"  autocomplete="off" aria-describedby="basic-addon5" required>
                                </div>
                                </div>
                            </div>
                            <div class="col-md-2"> 
                                <div class="form-group">                     
                                    <label> To Date</label>
                                    <div class='input-group date'>
                                    <input type="text" class="form-control datepicker2" id="toDate" name="to_date"  value="{{$to_date}}"  autocomplete="off" aria-describedby="basic-addon5" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">  
                            <div class="form-group" style="text-align:start;">                           
                                <button type="submit" style="margin-top: 33px;" class="btn btn-sm btn-primary search-btn " > <i class="fa fa-search"></i> </button>
                                <?php if($orders && count($orders) > 0){?> 
                                    <a style="color:white; " href="{{ route('admin.sales-report-pdf',['vendor'=> $vendor, 'from_date'=>$from_date , 'to_date' => $to_date])}}">
                                            <button type="button" style="margin-top: 33px;" class="btn btn-primary ">Export PDF</button> 
                                        </a>  
                                <?php } ?>   
                            </div>
                            </div>
                        </div>
                    </form> 
                </div>
            </div>
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Vendor Sales Report</h5>
                        </div>
                        <div class="col-6">
                            <ul class="list-inline-group text-right mb-0 pl-0">
                                 <li class="list-inline-item">
                                </li>
                            </ul>                          
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>order</th>
                                    <th>Grand Total</th>
                                                                            
                                </tr>
                            </thead>
                            <tbody>
                            @if (!count($orders))
                                <tr>
                                    <td colspan="3" class="text-center">Data not found.</td>
                                </tr>
                            @else
                            @foreach($orders as $order)
                                <tr>
                                    <td>{{date('d-m-Y', strtotime($order->created_at))}}</td>
                                    <td>{{$order->order->invoice_number}}</td>
                                    <td>{{$order->total_cost}}</td>
                                </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                 <div class="card-footer pagination ml-3">
                 </div>
            </div>
        </div>
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
<!-- End Contentbar -->
@endsection 
@section('script')

@endsection 