@section('title') 
Create Reseller
@endsection
@extends('admin-layouts.main')
@section('style')
<!-- Dropzone css -->
<link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/image-uploader.css') }}" rel="stylesheet" type="text/css">
@endsection 

 @section('rightbar-action') 

 <!-- <button class="btn btn-primary-rgba right-action"><i class="feather icon-plus mr-2"></i>Actions</button> -->
 @endsection 

 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                    </div>
                </div>
                <div class="card-body">
                <form method="POST" action="{{route('admin.reseller.create.p')}}" id="create-form" >
                {{csrf_field()}}
                <input type="hidden" id="id" value="">  
                <input type="hidden" id="is_active" name="is_active" value="1">
                <div class="row">
                <div class="col-md-6"> 
                        <div class="form-group has-feedback">          
                            <label> Users </label>
                            <select class="select2-single form-control" onkeydown="return false" id="user" name="user"  value="{{$user}}"  autocomplete="off">
                            <option  value="">Select User</option>
                            @foreach ($users as $user_item)
                            <option value="{{ $user_item->id }}" @if (old('user') == $user_item->id) selected="selected" @endif>{{ $user_item->name }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                   <div class="col-md-6">
                    <div class="form-group has-feedback">
                        <label for="reseller" class="col-form-label">Reseller Name</label>
                        <input type="text" class="form-control  {{ $errors->has('name') ? ' has-error' : '' }}"   
                            name="name"
                            id="name"
                            value="{{old('name')}}"
                            data-validation="required length" 
                            data-validation-length="3-200" 
                            data-validation-error-msg="Name is required &  limit to 3-200 characters."
                            placeholder="Name" 
                            required
                           />
                    </div>
                    @if ($errors->has('name'))
                        <span class="help-block">
                            <strong class="error-text">{{ $errors->first('name') }}</strong>
                        </span>
                    @endif
                    </div>
                    </div>
                    <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">Address</label>
                                <textarea name="address" id="address" class="form-control {{ $errors->has('address') ? ' has-error' : '' }}" placeholder="Address"  rows="3" required>{{old('address')}}</textarea>
                            </div>
                            @if ($errors->has('address'))
                                <span class="help-block">
                                <strong class="error-text">{{ $errors->first('address') }}</strong>
                                </span>
                            @endif
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Phone</label>
                                    <input  placeholder="Phone"  id="phone" name="phone" value="{{old('phone')}}" class="phone form-control {{ $errors->has('phone') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="12-12" data-validation-error-msg="The input field must be a valid mobile number. " required/>
                                </div>
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <div class="form-group has-feedback">
                                    <label for="whatsapp_no" class="col-form-label">WhatsApp Number</label>
                                    <input  placeholder="WhatsApp Number"  id="whatsapp_no" name="whatsapp_no" value="{{old('whatsapp_no')}}" class="form-control {{ $errors->has('whatsapp_no') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="12-12" data-validation-error-msg="The input field must be a valid whatsApp number. " required/>
                                </div>
                                @if ($errors->has('whatsapp_no'))
                                    <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('whatsapp_no') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group has-feedback">
                                        <label for="email" class="col-form-label">Email</label>
                                        <input id="email" name="email" value="{{old('email')}}"  class="form-control {{ $errors->has('email') ? ' has-error' : '' }}" type="email" placeholder="Email" data-validation="required email length"  data-validation-length="3-100" data-validation-error-msg="Please enter the valid  email address & limit to  3-100 characters.  " required/>
                                    </div>
                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group has-feedback">
                                    <input type="hidden" name="_token" id="csrf" value="{{Session::token()}}">
                                    <label for="color" class="col-form-label">Pincode</label>
                                    <input id="zipcode" name="pincode" value="{{old('pincode')}}" class="printchatbox form-control {{ $errors->has('pincode') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="6-6" data-validation-error-msg="The input field must be a valid pincode. " required/>
                                    <div class="row" style="padding-left:20px;padding-top:5px">
                                        <p style="color:#4F7942" id="address_id" name="address"></p>&nbsp<p style="color:#4F7942" id="city" name="city_id"></p>&nbsp<p style="color:#4F7942" id="state" name="state_id"></p>
                                    </div>
                                    </div>
                                    @if ($errors->has('pincode'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('pincode') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">Account Holder Name</label>
                                <input type="text" class="form-control {{ $errors->has('account_name') ? ' has-error' : '' }}"   
                                    name="account_name"
                                    id="account_name"
                                    value="{{old('account_name')}}"
                                    placeholder="Account Holder Name" 
                                />
                            </div>  
                            @if ($errors->has('account_name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('account_name') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">Account Number</label>
                                <input type="text" class="form-control {{ $errors->has('account_number') ? ' has-error' : '' }}"   
                                    name="account_number"
                                    id="account_number"
                                    value="{{old('account_number')}}"
                                    placeholder="Account Number" 
                                />
                            </div>  
                            @if ($errors->has('account_number'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('account_number') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="row">
                    <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">IFSC Code</label>
                                <input type="text" class="form-control {{ $errors->has('ifsc') ? ' has-error' : '' }}"   
                                    name="ifsc"
                                    id="ifsc"
                                    value="{{old('ifsc')}}"
                                    placeholder="IFSC Code" 
                                />
                            </div>  
                            @if ($errors->has('ifsc'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('ifsc') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">UPI ID</label>
                                <input type="text" class="form-control {{ $errors->has('upi_id') ? ' has-error' : '' }}"   
                                    name="upi_id"
                                    id="upi_id"
                                    value="{{old('upi_id')}}"
                                    placeholder="UPI ID" 
                                />
                            </div>  
                            @if ($errors->has('upi_id'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('upi_id') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">Bank Name</label>
                                <input type="text" class="form-control {{ $errors->has('bank_name') ? ' has-error' : '' }}"   
                                    name="bank_name"
                                    id="bank_name"
                                    value="{{old('bank_name')}}"
                                    placeholder="Bank  Name" 
                                />
                            </div>  
                            @if ($errors->has('bank_name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('bank_name') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">Branch Name</label>
                                <input type="text" class="form-control {{ $errors->has('branch_name') ? ' has-error' : '' }}"   
                                    name="branch_name"
                                    id="branch_name"
                                    value="{{old('branch_name')}}"
                                    placeholder="Branch Name" 
                                />
                            </div>  
                            @if ($errors->has('branch_name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('branch_name') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="row"  id="password_section">
                                <div class="col-md-6"  id="password">
                                    <div class="form-group has-feedback">
                                        <label for="password">Password</label>
                                        <input type="password" autocomplete="off" class="form-control {{ $errors->has('password') ? ' has-error' : '' }}" id="password_confirmation" name="password" value="{{old('password')}}" data-validation="required custom length" data-validation-length="6-200"  
                                                data-validation-regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$"
                                                data-validation-error-msg="The password isn't strong enough.Add 6 characters or more, lowercase letters, uppercase letters, numbers and symbols to make the password really strong." maxlength="100"
                                                >
                                    </div>
                                    @if ($errors->has('password'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('password') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-6"  id="confirm_password">
                                    <div class="form-group has-feedback">
                                        <label for="password">Confirm Password</label>
                                        <input type="password" autocomplete="off" class="form-control {{ $errors->has('confirm_password') ? ' has-error' : '' }}" id="password" name="confirm_password" value="{{old('confirm_password')}}" data-validation="confirmation"
                                        data-validation-error-msg="The password could not be confirmed." maxlength="100"
                                        >
                                    </div>
                                    @if ($errors->has('confirm_password'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('confirm_password') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                
                            </div>
                    </div>
                    </div>
                    <!-- End col -->
                    
                <div class="row">
                        <div class="col-12">
                            <div class="card m-b-30">
                                <div class="card-header">                                
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                        <button type="submit" class="btn btn-primary create-submit-btn">Create</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
                 </form>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            
        
        
    </div>
    <!-- End row -->
</div>
          

<!-- End Contentbar -->
@endsection 
@section('script')
<script>
$( document ).keyup(function() {
 
 var pincode = $( '#zipcode' ).val();
 $( '#address_id' ).val('');
 $( '#city' ).val('');
 $( '#state' ).val('');
 if(pincode!="" && pincode.length == 6){
        /*  $("#butsave").attr("disabled", "disabled"); */
          $.ajax({
              url: "/getLocation",
              type: "POST",
              data: {
                  _token: $("#csrf").val(),
                  pincode: pincode
              },
              cache: false,
              success: function(response){
                  $( '#address_id' ).html(response.data[0].address+',');
                  $( '#city' ).html(response.data[0].city['name']+',');
                  $( '#state' ).html(response.data[0].state['name']);
              }
          });
      }
});
</script>
<script>
$('#user').change(function() {
 
 var user = $( '#user' ).val();
 $( '#name' ).val('');
 $( '#address' ).val('');
 $( '#email' ).val('');
 $( '#phone' ).val('');
 $( '#whatsapp_no' ).val('');
 $( '#zipcode' ).val('');
 $( '#account_name' ).val('');
 $( '#account_number' ).val('');
 $( '#ifsc' ).val('');
 $( '#upi_id' ).val('');
 $( '#bank_name' ).val('');
 $( '#branch_name' ).val('');
 if(user!="" ){
      /*  $("#butsave").attr("disabled", "disabled"); */
        $.ajax({
            url: "/getVendor",
            type: "POST",
            data: {
                _token: $("#csrf").val(),
                user: user
            },
            cache: false,
            success: function(response){
                $( '#name' ).val(response.data.vendor.name);
                $( '#address' ).val(response.data.vendor.address);
                $( '#email' ).val(response.data.vendor.email);
                $( '#phone' ).val(response.data.vendor.phone);
                $( '#whatsapp_no' ).val(response.data.vendor.whatsapp_no);
                $( '#zipcode' ).val(response.data.vendor.pincode);
                $( '#account_name' ).val(response.data.vendor.account_name);
                $( '#account_number' ).val(response.data.vendor.account_number);
                $( '#ifsc' ).val(response.data.vendor.ifsc);
                $( '#upi_id' ).val(response.data.vendor.upi_id);
                $( '#bank_name' ).val(response.data.vendor.bank_name);
                $( '#branch_name' ).val(response.data.vendor.branch_name);
                $( '#password' ).css('display','none');
                $( '#confirm_password' ).css('display','none');
                
            }
        });
    }
    else
    {
        $( '#password' ).css('display','block');
        $( '#confirm_password' ).css('display','block');
    }
});
</script>
<script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script>    
<script src="{{ asset('assets/js/custom/custom-form-select.js') }}"></script>
@endsection 
