@section('title') 
Edit Vendor
@endsection
@extends('admin-layouts.main')
@section('style')

@endsection 

 @section('rightbar-action') 

 <!-- <button class="btn btn-primary-rgba right-action"><i class="feather icon-plus mr-2"></i>Actions</button> -->
 @endsection 

 
@section('rightbar-content')
<!-- Start Contentbar -->    
<div class="contentbar">                
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">                                
                    <div class="row align-items-center">
                    </div>
                </div>
                <div class="card-body">
                <form method="POST" action="{{route('admin.vendor.update.p', $vendor->id)}}" id="create-form" >
                {{csrf_field()}}
                <input type="hidden" id="id" value="">
                <input type="hidden" id="is_active" name="is_active" value="{{$vendor->is_active}}">
                <div class="row">
                   <div class="col-md-6">
                    <div class="form-group has-feedback">
                        <label for="vendor" class="col-form-label">Vendor Name</label>
                        <input type="text" class="form-control  {{ $errors->has('name') ? ' has-error' : '' }}"   
                            name="name"
                            id="name"
                            value="{{old('name', $vendor->name)}}"
                            data-validation="required length" 
                            data-validation-length="3-200" 
                            data-validation-error-msg="Name is required &  limit to 3-200 characters."
                            placeholder="Name"
                           />
                    </div>
                    @if ($errors->has('name'))
                        <span class="help-block">
                            <strong class="error-text">{{ $errors->first('name') }}</strong>
                        </span>
                    @endif
                    </div>
                    <div class="col-md-6">
                        <div class="form-group has-feedback">
                            <label for="email" class="col-form-label">Email</label>
                            <input id="email" name="email" value="{{old('email', $vendor->email)}}"  class="form-control {{ $errors->has('email') ? ' has-error' : '' }}" type="email" placeholder="Email" data-validation="required email length"  data-validation-length="3-100" data-validation-error-msg="Please enter the valid  email address & limit to  3-100 characters.  "/>
                        </div>
                        @if ($errors->has('email'))
                            <span class="help-block">
                                <strong class="error-text">{{ $errors->first('email') }}</strong>
                            </span>
                        @endif
                    </div>
                    </div>
                    <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">Address</label>
                                <textarea name="address" id="address" class="form-control {{ $errors->has('address') ? ' has-error' : '' }}" placeholder="Address"  rows="3">{{old('address', $vendor->address)}}</textarea>
                            </div>
                            @if ($errors->has('address'))
                                <span class="help-block">
                                <strong class="error-text">{{ $errors->first('address') }}</strong>
                                </span>
                            @endif
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group has-feedback">
                                    <label for="color" class="col-form-label">Phone</label>
                                    <input  placeholder="Phone"  id="phone" name="phone" value="{{old('phone', $vendor->phone)}}" class="phone form-control {{ $errors->has('phone') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="12-12" data-validation-error-msg="The input field must be a valid mobile number. "/>
                                </div>
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <div class="form-group has-feedback">
                                    <label for="whatsapp_no" class="col-form-label">WhatsApp Number</label>
                                    <input  placeholder="WhatsApp Number"  id="whatsapp_no" name="whatsapp_no" value="{{old('whatsapp_no', $vendor->whatsapp_no)}}" class="form-control {{ $errors->has('whatsapp_no') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="12-12" data-validation-error-msg="The input field must be a valid whatsApp number. "/>
                                </div>
                                @if ($errors->has('whatsapp_no'))
                                    <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('whatsapp_no') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group has-feedback">
                                        <label for="pincode" class="col-form-label">Pincode</label>
                                    <input  id="pincode" name="pincode" value="{{old('pincode', $vendor->pincode)}}" class="form-control {{ $errors->has('pincode') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="6-6" data-validation-error-msg="The input field must be a valid pincode. "/>
                                    </div>
                                    @if ($errors->has('pincode'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('pincode') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group has-feedback">
                                        <label for="gst" class="col-form-label">GST</label>
                                        <input id="gst" name="gst" placeholder="GSTIN" value="{{old('gst', $vendor->gst)}}" class="form-control {{ $errors->has('gst') ? ' has-error' : '' }}" type="text" data-validation="required number length"  data-validation-length="6-6" data-validation-error-msg="The input field must be a valid gst. "/>
                                    </div>
                                    @if ($errors->has('gst'))
                                        <span class="help-block">
                                            <strong class="error-text">{{ $errors->first('gst') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">Account Holder Name</label>
                                <input type="text" class="form-control {{ $errors->has('account_name') ? ' has-error' : '' }}"   
                                    name="account_name"
                                    id="account_name"
                                    placeholder="Account Holder Name" 
                                    value="{{old('account_name', $vendor->account_name)}}"
                                />
                            </div>  
                            @if ($errors->has('account_name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('account_name') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">Account Number</label>
                                <input type="text" class="form-control {{ $errors->has('account_number') ? ' has-error' : '' }}"   
                                    name="account_number"
                                    id="account_number"
                                    placeholder="Account Number" 
                                    value="{{old('account_number', $vendor->account_number)}}"
                                />
                            </div>  
                            @if ($errors->has('account_number'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('account_number') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="row">
                    <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">IFSC Code</label>
                                <input type="text" class="form-control {{ $errors->has('ifsc') ? ' has-error' : '' }}"   
                                    name="ifsc"
                                    id="ifsc"
                                    placeholder="IFSC Code" 
                                    value="{{old('ifsc', $vendor->ifsc)}}"
                                />
                            </div>  
                            @if ($errors->has('ifsc'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('ifsc') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group has-feedback">
                                <label for="color" class="col-form-label">UPI ID</label>
                                <input type="text" class="form-control {{ $errors->has('upi_id') ? ' has-error' : '' }}"   
                                    name="upi_id"
                                    id="upi_id"
                                    placeholder="UPI ID" 
                                    value="{{old('upi_id', $vendor->upi_id)}}"
                                />
                            </div>  
                            @if ($errors->has('upi_id'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('upi_id') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">Bank  Name</label>
                                <input type="text" class="form-control {{ $errors->has('bank_name') ? ' has-error' : '' }}"   
                                    name="bank_name"
                                    id="bank_name"
                                    placeholder="Bank  Name" 
                                    value="{{old('bank_name', $vendor->bank_name)}}"
                                />
                            </div>  
                            @if ($errors->has('bank_name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('bank_name') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="form-group  has-feedback">
                                <label for="color" class="col-form-label">Branch  Name</label>
                                <input type="text" class="form-control {{ $errors->has('branch_name') ? ' has-error' : '' }}"   
                                    name="branch_name"
                                    id="branch_name"
                                    placeholder="Branch Name" 
                                    value="{{old('branch_name', $vendor->branch_name)}}"
                                />
                            </div>  
                            @if ($errors->has('branch_name'))
                                <span class="help-block">
                                    <strong class="error-text">{{ $errors->first('branch_name') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    </div>
                    </div>
                    <!-- End col -->
                <div class="row">
                        <div class="col-12">
                            <div class="card m-b-30">
                                <div class="card-header">                                
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                        <button type="submit" class="btn btn-primary create-submit-btn">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
                 </form>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 pagination"></div>
                    </div>
                </div>
            </div>
        
        <!-- End col -->
    </div>
    <!-- End row -->
</div>
      

<!-- End Contentbar -->
@endsection 
@section('script')
@endsection 
