@props([
'id' => 'autocomplete-'. uniqid(),
'placeholder' => 'Search...',
'indexName' => 'books',
'publicKey' => '39b2cbcf178c72e6fdd09176fa788bebfb824acccc2ece91bda456d4d2b44380',
'host' => 'http://127.0.0.1:7700',
])


<div
    x-data="{
        client: null,
        host: '{{ $host }}',
        apiKey: '{{ $publicKey }}',
        searchString: '',
        results: {
            hits: [],
        },
        state: 'idle',
        highlightedIndex: 0,

        async search() {
            this.state = 'searching';
            if (this.searchString.length > 0) {
                this.results = await this.client.index('{{ $indexName }}').search(this.searchString);
                this.state = 'finished';
            } else {
                this.results.hits = [];
                this.state = 'idle';
            }
        },

        highlightPrevious() {
            if (this.highlightedIndex > 0) {
                this.highlightedIndex -= 1;
                this.scrollIntoView();
            }
        },

        highlightNext() {
            if (this.highlightedIndex < this.results.hits.length - 1) {
                this.highlightedIndex += 1;
                this.scrollIntoView();
            }
        },

        scrollIntoView() {
            this.$refs.results.children[this.highlightedIndex].scrollIntoView({
                block: 'nearest',
                behavior: 'smooth'
            });
        },

        goToLink() {
            const selectedItem = this.results.hits[this.highlightedIndex];
            if (selectedItem) {
                window.location.href = selectedItem.url; // Ensure your search result contains a 'url' field.
            }
        }
    }"
    x-init="client = new MeiliSearch({ host: host, apiKey: apiKey })"
    class="relative w-full"
    x-cloak
>
    <div class="relative">
        <input
            type="search"
            autocomplete="off"
            class="form-input bg-gray-50 border-gray-300 rounded-lg shadow-sm pl-10 pr-4 py-2 w-full"
            placeholder="{{ $placeholder }}"
            x-model="searchString"
            @input.debounce.500ms="search()"
            @keydown.arrow-down.prevent="highlightNext()"
            @keydown.arrow-up.prevent="highlightPrevious()"
            @keydown.enter.prevent="goToLink()"
        />

        <svg class="w-5 h-5 text-gray-400 absolute left-3 top-1/2 transform -translate-y-1/2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 6a6 6 0 118 0M8 6l10 10-10-10z" />
        </svg>

        <!-- Loading Spinner -->
        <div class="absolute right-4 top-1/2 transform -translate-y-1/2" x-show="state === 'searching'">
            <svg class="animate-spin h-5 w-5 text-gray-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path d="M12 2a10 10 0 00-10 10h2a8 8 0 018-8V2z" fill="currentColor"></path>
            </svg>
        </div>
    </div>

    <!-- Search Results Dropdown -->
    <div
        class="absolute mt-2 w-full bg-white border border-gray-300 rounded-lg shadow-lg z-50"
        x-show="searchString.length > 0 && results.hits.length > 0"
        style="max-height: 400px; overflow-y: auto;"
        @click.away="searchString = ''; results.hits = []"
    >
        <ul x-ref="results">
            <template x-for="(result, index) in results.hits" :key="index">
                <li
                    :class="{'bg-indigo-600 text-white': highlightedIndex === index}"
                    class="cursor-pointer px-4 py-2 hover:bg-indigo-600 hover:text-white"
                    @click="window.location.href = result.url" {{-- Redirect when a result is clicked --}}
                    @mouseenter="highlightedIndex = index"
                >
                    <span x-text="result.title"></span>
                </li>
            </template>
        </ul>
    </div>

    <!-- No Results Message -->
    <div
        class="absolute mt-2 w-full bg-white border border-gray-300 rounded-lg shadow-lg z-50 p-4 text-center text-gray-500"
        x-show="searchString.length > 0 && results.hits.length === 0 && state === 'finished'"
    >
        No results found.
    </div>
</div>

<!-- MeiliSearch CDN -->
<script src="https://cdn.jsdelivr.net/npm/meilisearch@latest/dist/bundles/meilisearch.umd.js"></script>
