@section('title')
Checkout
@endsection
@extends('frontend-layouts.main')

@section('style')
@endsection

@section('content')



<div class="page-wrapper">
    <div class="page-content">
        <!--start breadcrumb-->
        <section class="py-3 border-bottom border-top d-none d-md-flex bg-light">
            <div class="container">
                <div class="page-breadcrumb d-flex align-items-center">
                    <h3 class="breadcrumb-title pe-3">Checkout</h3>
                    <div class="ms-auto">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 p-0">
                                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i> Home</a>
                                </li>
                                <li class="breadcrumb-item"><a href="javascript:;">Shop</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Checkout</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </section>
        <!--end breadcrumb-->
        <!--start shop cart-->
        <section class="py-4">
            <div class="container">
                <div class="shop-cart">
                    <div class="row">
                        <div class="col-12 col-xl-8">
                            <div class="checkout-details">
                                <div class="card bg-transparent rounded-0 shadow-none">
                                    <div class="card-body">
                                        <div class="steps steps-light">
                                            <a class="step-item active" href="{{url('/cart')}}">
                                                <div class="step-progress"><span class="step-count">1</span>
                                                </div>
                                                <div class="step-label"><i class='bx bx-cart'></i>Cart</div>
                                            </a>
                                            <a class="step-item active current" href="{{url('/checkout')}}">
                                                <div class="step-progress"><span class="step-count">2</span>
                                                </div>
                                                <div class="step-label"><i class='bx bx-user-circle'></i>Details</div>
                                            </a>

                                            <a class="step-item" href="{{url('/checkout-payment')}}">
                                                <div class="step-progress"><span class="step-count">3</span>
                                                </div>
                                                <div class="step-label"><i class='bx bx-credit-card'></i>Payment</div>
                                            </a>

                                        </div>
                                    </div>
                                </div>
                                <div class="card rounded-0">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="">
                                                <img src="assets/images/avatars/avatar-1.png" width="90" alt="" class="rounded-circle p-1 border">
                                            </div>
                                            <div class="ms-2">
                                                <h6 class="mb-0">
                                                    @if(Auth::check())
                                                    <span class="logined-user-name">{{ Auth::user()->name }}</span>
                                                    @endif
                                                </h6>
                                                <p class="mb-0">
                                                    @if(Auth::check())
                                                    <span class="logined-user-name">{{ Auth::user()->email }}</span>
                                                    @endif


                                                </p>
                                            </div>
                                            <div class="ms-auto"> <a href="javascript:;" class="btn btn-light btn-ecomm"><i class='bx bx-edit'></i> Edit Profile</a>
                                            </div>
                                        </div>
                                        <div class="border p-3">
                                            <h2 class="h5 mb-0">Shipping Address</h2>
                                            <div class="my-3 border-bottom"></div>
                                            <div class="form-body">
                                                <form class="row g-3" action="{{ route('save.user.address') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="address_id" value="{{ $user_address ? $user_address->id : '' }}">

                                                    <div class="col-md-12">
                                                        <label class="form-label">Name</label>
                                                        <input type="text" class="form-control rounded-0" value="{{ $user_address ? $user_address->contact_name : '' }}" name="contact_name">
                                                        @error('contact_name')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="form-label">E-mail id</label>
                                                        <input type="text" class="form-control rounded-0" value="{{ $user_address ? $user_address->email : '' }}" name="email">
                                                        @error('email')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="form-label">Phone Number</label>
                                                        <input type="text" class="form-control rounded-0" value="{{ $user_address ? $user_address->mobile_number : '' }}" name="mobile_number">
                                                        @error('mobile_number')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="form-label">Pincode</label>
                                                        <input type="text" class="form-control rounded-0" value="{{ $user_address ? $user_address->pincode : '' }}" name="pincode">
                                                        @error('pincode')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="form-label">State</label>
                                                        <select class="form-select rounded-0" name="state_id">
                                                            <option value="">Select a State</option>
                                                            @foreach($states as $state)
                                                            <option value="{{ $state->id }}" @if($user_address && $user_address->state_id == $state->id) selected @endif>{{ $state->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        @error('state_id')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="form-label">Address 1</label>
                                                        <textarea class="form-control rounded-0" name="house_name">{{ $user_address ? $user_address->house_name : '' }}</textarea>
                                                        @error('house_name')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="form-label">Address 2</label>
                                                        <textarea class="form-control rounded-0" name="landmark">{{ $user_address ? $user_address->landmark : '' }}</textarea>
                                                        @error('landmark')
                                                        <div class="text-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="d-grid">
                                                            <a href="{{ url('/cart') }}" class="btn btn-light btn-ecomm"><i class='bx bx-chevron-left'></i> Back to Cart</a>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="d-grid">
                                                            <button class="btn btn-dark btn-ecomm">Proceed to Checkout <i class='bx bx-chevron-right'></i></button>
                                                        </div>
                                                    </div>
                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-xl-4">
                            <div class="order-summary">
                                <div class="card rounded-0">
                                    <div class="card-body">

                                        <div class="card rounded-0 border bg-transparent shadow-none">
                                            <div class="card-body" id="checkout_item_products">
                                                <p class="fs-5">Order summary</p>


                                            </div>
                                        </div>
                                        <div class="card rounded-0 border bg-transparent mb-0 shadow-none">
                                            <div class="card-body">
                                                <p class="mb-2">Subtotal: <span class="float-end">₹ <span class="sub_total_cart"></span></span>
                                                </p>
                                                <p class="mb-2">Shipping: <span class="float-end">₹<span class="cart_shipping_charge"></span>
                                                </p>

                                                <p class="mb-0">Discount: <span class="float-end">₹<span class="cart_discount_charge"></span>
                                                </p>
                                                <div class="my-3 border-top"></div>
                                                <h5 class="mb-0">Order Total: <span class="float-end"> ₹<span class="cart_grand_total"></span></span></h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end row-->
                </div>
            </div>
        </section>
        <!--end shop cart-->
    </div>
</div>


@endsection

@section('script')
<script>
    $(document).ready(function() {
        renderCheckoutItems();
    });
</script>
@endsection