@section('title')
Book at Door - India's No.1 All-in-One Book Store
@endsection
@extends('frontend-layouts.main')

@section('style')

@endsection

@section('content')


<section class="slider-section">
    <div class="first-slider p-0">

        <div class="banner-slider owl-carousel owl-theme">
            @foreach ($banners as $banner)
            <div class="item">
                <div class="position-relative">
                    <!-- Desktop banner -->
                    <a href="{{ $banner->link }}" class="d-none d-md-block">
                        <img src="{{ $banner->image }}" class="img-fluid product_image" alt="{{ $banner->name }}">
                    </a>

                    <!-- Mobile banner -->
                    <a href="{{ $banner->link }}" class="d-block d-md-none">
                        <img src="{{ $banner->mobile_banner }}" class="img-fluid product_image" alt="{{ $banner->name }}">
                    </a>
                </div>
            </div>
            @endforeach
        </div>


    </div>
</section>
<!-- MOB CATEGRY -->
<section class="MobCategory">
    <div class="container">
        <ul>
            @foreach($categories->take(10) as $category)
            <li>
                <div class="Cont">
                    <a href="">
                        <img src="{{$category->logo}}" width="100" alt="">
                        <h6> {{ $category->name }}</h6>
                    </a>
                </div>
            </li>
            @endforeach
        </ul>
    </div>
</section>
<!--start slider section-->
<!--end slider section-->
<!--start page wrapper -->

<div class="page-content">
    <!--start information-->

    <!--end information-->
    <!--start New Arrivals-->
    <section class="py-4">
        <div class="container">
            <div class="separator pb-4">

                <h5 class="mb-0 fw-bold separator-title">New Arrivals</h5>
                <div class="line"></div>
            </div>
            <div class="product-grid">
                <div class="new-arrivals owl-carousel owl-theme position-relative">

                    @foreach($new_arrivals as $new_arrival)

                    <div class="item">
                        <div class="card">
                            <div class="position-relative overflow-hidden">
                                <div class="add-cart position-absolute top-0 end-0 mt-3 me-3">
                                    <a href="{{ url('/'.$new_arrival->slug)}}"><i class='bx bx-cart-add'></i></a>
                                </div>
                                <div class="quick-view position-absolute start-0 bottom-0 end-0">
                                    <a href="{{ url('/'.$new_arrival->slug)}}">Quick View</a>
                                </div>
                                <a href="{{ url('/'.$new_arrival->slug)}}">
                                    <div class="ImageCard">
                                        <img src="{{ $new_arrival->image}}" class="img-fluid product_image" alt="...">
                                    </div>
                                </a>
                            </div>
                            <div class="card-body px-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="">
                                        <p class="mb-1 product-short-name">Topwear</p>
                                        <h6 class="mb-0 fw-bold product-short-title">{{$new_arrival->name}}</h6>
                                    </div>

                                </div>

                                <div class="product-price d-flex align-items-center justify-content-start gap-2 mt-2">
                                    <div class="h6 fw-light fw-bold text-secondary text-decoration-line-through">₹{{$new_arrival->price}}</div>
                                    <div class="h6 fw-bold">₹{{$new_arrival->price}}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <!--end New Arrivals-->


    <!--start pramotion-->
    <section class="py-4">
        <div class="container">
            <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 g-4 Catcard">
                <div class="col mobM">
                    <div class="card rounded-0 shadow-none card-1 bg-opacity-25">
                        <div class="row g-0 align-items-center">
                            <div class="col-5 col">
                                <img src="{{ asset('frontend/images/promo/01.png')}}" class="img-fluid" alt="" />
                            </div>
                            <div class="col">
                                <div class="card-body">
                                    <h5 class="card-title text-uppercase fw-bold"> All India Exams</h5>
                                    <p class="card-text text-uppercase">Starting at ₹9</p>
                                    <a href="#" class="btn btn-outline-dark btn-ecomm">SHOP NOW</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col mobM">
                    <div class="card rounded-0 shadow-none card-2 bg-opacity-25">
                        <div class="row g-0 align-items-center">
                            <div class="col-5 col">
                                <img src="{{ asset('frontend/images/promo/02.png')}}" class="img-fluid" alt="" />
                            </div>
                            <div class="col">
                                <div class="card-body">
                                    <h5 class="card-title text-uppercase fw-bold">Kerala PSC</h5>
                                    <p class="card-text text-uppercase">Starting at ₹20</p> <a href="#" class="btn btn-outline-dark btn-ecomm">SHOP NOW</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col mobM">
                    <div class="card rounded-0 shadow-none card-3 bg-opacity-25">
                        <div class="row g-0 align-items-center">
                            <div class="col-5 col">
                                <img src="{{ asset('frontend/images/promo/03.png')}}" class="img-fluid" alt="" />
                            </div>
                            <div class="col">
                                <div class="card-body">
                                    <h5 class="card-title text-uppercase fw-bold">Academic Books</h5>
                                    <p class="card-text text-uppercase">Starting at ₹30</p><a href="#" class="btn btn-outline-dark btn-ecomm">SHOP NOW</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end row-->
        </div>
    </section>
    <!--end pramotion-->
    <!--start Featured product-->
    <section class="py-4">
        <div class="container">
            <div class="separator pb-4">

                <h5 class="mb-0 fw-bold separator-title">Top Reads Books</h5>
                <div class="line"></div>
            </div>
            <div class="product-grid">
                <div class="row row-cols-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-4 row-cols-xxl-6 g-3 g-sm-4">
                    @foreach($featured_products as $featured_product)
                    <div class="col CardBorder">
                        <div class="card">
                            <div class="position-relative overflow-hidden">
                                <div class="add-cart position-absolute top-0 end-0 mt-3 me-3">
                                    <a href="{{ url('/'.$featured_product->slug) }}"><i class='bx bx-cart-add'></i></a>
                                </div>
                                <div class="quick-view position-absolute start-0 bottom-0 end-0">
                                    <a href="{{ url('/'.$featured_product->slug) }}">Quick View</a>
                                </div>
                                <div class="Imag">
                                    <a href="{{ url('/'.$featured_product->slug) }}">
                                        <img src="{{$featured_product->image}}" class="img-fluid product_image" alt="...">
                                    </a>
                                </div>
                            </div>
                            <div class="card-body px-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="">
                                        <p class="mb-1 product-short-name">Topwear</p>
                                        <h6 class="mb-0 fw-bold product-short-title">{{$featured_product->name}}</h6>
                                    </div>

                                </div>

                                <div class="product-price d-flex align-items-center justify-content-start gap-2 mt-2">
                                    <div class="h6 fw-light fw-bold text-secondary text-decoration-line-through">₹{{$featured_product->mrp}}</div>
                                    <div class="h6 fw-bold">₹{{$featured_product->price}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach

                </div><!--end row-->

            </div>
        </div>
    </section>
    <!--end Featured product-->
    <!--start Advertise banners-->
    <section class="py-5 bg-dark">
        <div class="container">
            <div class="add-banner">
                <h3 style="color: #fff; text-align:center;" class="mb-4">Explore Our Big Box!</h3>
                <div class=" offer owl-carousel owl-theme">
                    <div class="item">
                        <div class="card rounded-0 w-100 border-0 shadow-none">
                            <img src="{{ asset('frontend/images/promo/04.png')}}" class="img-fluid" alt="...">
                            <div class="position-absolute top-0 end-0 m-3 product-discount"><span class="">-10%</span>
                            </div>

                        </div>
                    </div>
                    <div class="item">
                        <div class="card rounded-0 w-100 border-0 shadow-none">
                            <img src="{{ asset('frontend/images/promo/08.png')}}" class="img-fluid" alt="...">
                            <div class="position-absolute top-0 end-0 m-3 product-discount"><span class="">-80%</span>
                            </div>

                        </div>
                    </div>
                    <div class="item">
                        <div class="card rounded-0 w-100 border-0 shadow-none">
                            <img src="{{ asset('frontend/images/promo/06.png')}}" class="img-fluid h-100" alt="...">
                            <div class="card-img-overlay text-center top-20">

                            </div>
                        </div>
                    </div>
                    <div class="item">
                        <div class="card rounded-0 w-100 border-0 shadow-none">
                            <div class="position-absolute top-0 end-0 m-3 product-discount"><span class="">-50%</span>
                            </div>
                            <img src="{{ asset('frontend/images/promo/07.png')}}" class="img-fluid" alt="...">

                        </div>
                    </div>
                </div>
                <!--end row-->
            </div>
        </div>
    </section>
    <!--end Advertise banners-->


    <!--start bottom products section-->
    <section class="py-4 border-top">
        <div class="container">
            <div class="row row-cols-1 row-cols-md-2 row-cols-xl-3">
                <div class="col">
                    <div class="bestseller-list mb-3">
                        <h6 class="mb-3 text-uppercase fw-bold">Best Selling Kerala PSC</h6>
                        <hr>

                        @foreach($footer_bestsellings as $footer_bestselling)
                        <div class="d-flex align-items-center gap-3">
                            <a href="{{ url('/'.$footer_bestselling->slug)}}">
                                <div class="bottom-product-img">
                                    <img src="{{$footer_bestselling->image}}" width="80" alt="">
                                </div>
                            </a>
                            <div class="">
                                <a href="{{ url('/'.$footer_bestselling->slug)}}">
                                    <h6 class="mb-0 fw-light mb-1 fw-bold footer_product_title">{{$footer_bestselling->name}}</h6>
                                    <p class="mb-0 pro-price"><strong>₹{{$footer_bestselling->price}}</strong></p>
                                </a>
                            </div>
                        </div>
                        <hr />
                        @endforeach







                    </div>
                </div>
                <div class="col">
                    <div class="featured-list mb-3">
                        <h6 class="mb-3 text-uppercase fw-bold">Readers Recommended</h6>
                        <hr>
                        @foreach($footer_featureds as $footer_featured)

                        <div class="d-flex align-items-center gap-3">
                            <a href="{{ url('/'.$footer_featured->slug)}}">
                                <div class="bottom-product-img">
                                    <img src="{{$footer_featured->image}}" width="80" alt="">
                                </div>
                            </a>
                            <div class="ms-0">
                                <a href="{{ url('/'.$footer_featured->slug)}}">
                                    <h6 class="mb-0 fw-light mb-1 fw-bold footer_product_title">{{$footer_featured->name}}</h6>
                                    <p class="mb-0 pro-price"><strong>₹{{$footer_featured->price}}</strong></p>
                                </a>
                            </div>
                        </div>
                        <hr />
                        @endforeach



                    </div>
                </div>

                <div class="col">
                    <div class="top-rated-products-list mb-4">
                        <h6 class="mb-3 text-uppercase fw-bold">Competitive Trending</h6>
                        <hr>
                        @foreach($footer_rated as $rated)

                        <div class="d-flex align-items-center gap-3">
                            <a href="{{ url('/'.$rated->slug)}}">
                                <div class="bottom-product-img">
                                    <img src="{{ $rated->image}}" width="80" alt="">
                                </div>
                            </a>
                            <div class="ms-0">
                                <a href="{{ url('/'.$rated->slug)}}">
                                    <h6 class="mb-0 fw-light mb-1 fw-bold footer_product_title">{{$rated->name}}</h6>
                                    <p class="mb-0 pro-price"><strong>₹{{$rated->price}}</strong>
                                    </p>
                                </a>
                            </div>
                        </div>
                        <hr />
                        @endforeach

                    </div>
                </div>
            </div>
            <!--end row-->
        </div>
    </section>
    <!--end bottom products section-->
</div>


@endsection

@section('script')

@endsection