@section('title')
Book At Door About
@endsection
@extends('frontend-layouts.main')

@section('style')
<style>
    .product_image {
        width: 100%;
    }

    .product-short-title {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        /* Limit to 1 line */
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
    }
</style>
@endsection

@section('content')

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--start breadcrumb-->
        <section class="py-3 border-bottom border-top d-none d-md-flex bg-light">
            <div class="container">
                <div class="page-breadcrumb d-flex align-items-center">
                    <!-- <h3 class="breadcrumb-title pe-3">Shop Grid Left Sidebar</h3> -->
                    <div class="ms-auto">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 p-0">
                                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i> Home</a>
                                </li>
                                <li class="breadcrumb-item"><a href="javascript:;">Shop</a>
                                </li>

                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </section>
        <!--end breadcrumb-->
        <!--start shop area-->
        <section class="py-4">
            <div class="container">
                <div class="btn btn-dark btn-ecomm d-xl-none position-fixed top-50 start-0 translate-middle-y z-index-1" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbarFilter"><span><i class='bx bx-filter-alt me-1'></i>Filters</span></div>
                <div class="row">
                    <div class="col-12 col-xl-3 filter-column">
                        <nav class="navbar navbar-expand-xl flex-wrap p-0">
                            <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbarFilter" aria-labelledby="offcanvasNavbarFilterLabel">
                                <div class="offcanvas-header">
                                    <h5 class="offcanvas-title mb-0 fw-bold" id="offcanvasNavbarFilterLabel">Filters</h5>
                                    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                                </div>
                                <div class="offcanvas-body">
                                    <div class="filter-sidebar">
                                        <div class="card rounded-0 shadow-none border">
                                            <div class="card-header d-none d-xl-block bg-transparent">
                                                <h5 class="mb-0 fw-bold">Filters</h5>
                                            </div>
                                            <div class="card-body">
                                                <h6 class="p-1 fw-bold bg-light">Categories</h6>
                                                <div class="categories">
                                                    <div class="categories-wrapper height-1 p-1">
                                                        @foreach($categories as $category)
                                                        <div class="form-check">
                                                            <input class="form-check-input search_category_radio_btn" type="radio" value="{{ $category['slug'] }}" name="search_category" id="chekCate{{ $category['id'] }}">
                                                            <label class="form-check-label" for="chekCate{{ $category['id'] }}">
                                                                <span>{{ $category['name'] }}</span>
                                                                <!-- <span class="product-number">({{ $category['count'] }})</span> -->
                                                            </label>
                                                        </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="brands">
                                                    <h6 class="p-1 fw-bold bg-light">Tags</h6>
                                                    <div class="brands-wrapper height-1 p-1">
                                                        @foreach($tags as $tag)
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" value="" id="chekTag{{ $tag['id'] }}">
                                                            <label class="form-check-label" for="chekTag{{ $tag['id'] }}">
                                                                <span>{{ $tag['name'] }}</span>
                                                            </label>
                                                        </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="Price">
                                                    <h6 class="p-1 fw-bold bg-light">Price</h6>
                                                    <div class="Price-wrapper p-1">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control rounded-0" placeholder="₹10">
                                                            <span class="input-group-text bg-section-1 border-0">-</span>
                                                            <input type="text" class="form-control rounded-0" placeholder="₹10000">
                                                            <button type="button" class="btn btn-outline-dark rounded-0 ms-2"><i class='bx bx-chevron-right me-0'></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <hr>



                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                    </div>
                    <div class="col-12 col-xl-9">
                        <div class="product-wrapper">
                            <div class="toolbox d-flex align-items-center mb-3 gap-2 border p-3">
                                <div class="d-flex flex-wrap flex-grow-1 gap-1">
                                    <div class="d-flex align-items-center flex-nowrap">
                                        <p class="mb-0 font-13 text-nowrap">Sort By:</p>
                                        <select class="form-select ms-3 rounded-0">
                                            <option value="menu_order" selected="selected">Default sorting</option>
                                            <option value="popularity">Sort by popularity</option>
                                            <option value="date">Sort by newness</option>
                                            <option value="price">Sort by price: low to high</option>
                                            <option value="price-desc">Sort by price: high to low</option>
                                        </select>
                                    </div>
                                </div>


                            </div>
                            <div class="product-grid product_list_listpage">
                                <div class="row row-cols-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-4 row-cols-xxl-5 g-3 g-sm-4">

                                    <!-- List items -->


                                </div>

                            </div>
                            <hr>
                            <nav class="d-flex justify-content-between" aria-label="Page navigation">

                                <ul class="pagination">

                                </ul>

                            </nav>
                        </div>
                    </div>
                </div>
                <!--end row-->
            </div>
        </section>
        <!--end shop area-->
    </div>
</div>
<!--end page wrapper -->



@endsection
@section('script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let currentPage = 1;
        let isLoading = false;
        let lastPage = false;
        let selectedCategory = null;

        function fetchProducts(page = 1) {
            if (isLoading || lastPage) return;
            isLoading = true;
            let url = '/product/list';
            let params = {
                page: page
            };
            console.log(selectedCategory);
            if (selectedCategory) {
                params.category = selectedCategory;
            }
            axios.get(url, {
                    params
                })
                .then(function(response) {
                    const products = response.data.data.products.data;
                    const pagination = response.data.data.products;
                    const productGrid = document.querySelector('.product_list_listpage .row');
                    products.forEach(product => {
                        const productCard = `
                            <div class="col">
                                <div class="card">
                                    <div class="position-relative overflow-hidden">
                                        <div class="add-cart position-absolute top-0 end-0 mt-3 me-3">
                                            <a href="javascript:;"><i class='bx bx-cart-add'></i></a>
                                        </div>
                                        <div class="quick-view position-absolute start-0 bottom-0 end-0">
                                            <a href="/${product.slug}">View Details</a>
                                        </div>
                                        <a href="/${product.slug}">
                                        <div class="ImageCard">
                                            <img src="${product.image}" class="img-fluid product_image" alt="${product.name}">
                                             </div>
                                        </a>
                                    </div>
                                    <div class="card-body px-0">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="">
                                                <p class="mb-1 product-short-name">${product.category}</p>
                                                <h6 class="mb-0 fw-bold product-short-title">${product.name}</h6>
                                            </div>
                                        </div>
                                        
                                        <div class="product-price d-flex align-items-center justify-content-start gap-2 mt-2">
                                            ${product.mrp ? `<div class="h6 fw-light fw-bold text-secondary text-decoration-line-through">₹${product.mrp}</div>` : ''}
                                            <div class="h6 fw-bold">₹${product.price}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;

                        productGrid.insertAdjacentHTML('beforeend', productCard);
                    });
                    updatePagination(pagination);
                    isLoading = false;
                })
                .catch(function(error) {
                    console.error('Error fetching products:', error);
                    isLoading = false;
                });
        }

        function updatePagination(pagination) {
            const paginationControls = document.querySelector('.pagination');
            paginationControls.innerHTML = '';
            if (pagination.current_page < pagination.last_page) {
                paginationControls.insertAdjacentHTML('beforeend', `
                    <li class="page-item">
                        <button class="load-more-btn btn btn-primary">Load More</button>
                    </li>
                `);
                const loadMoreBtn = document.querySelector('.load-more-btn');
                loadMoreBtn.addEventListener('click', function() {
                    const nextPage = pagination.current_page + 1;
                    fetchProducts(nextPage);
                });
            } else {
                lastPage = true;
            }
        }

        function handleScroll() {
            const {
                scrollTop,
                scrollHeight,
                clientHeight
            } = document.documentElement;

            if (scrollTop + clientHeight >= scrollHeight - 5 && !isLoading) {
                const loadMoreBtn = document.querySelector('.load-more-btn');
                if (loadMoreBtn) {
                    loadMoreBtn.click(); // Simulate a click on the "Load More" button
                }
            }
        }



        document.querySelectorAll('.search_category_radio_btn').forEach((radio) => {
            radio.addEventListener('change', function() {
                console.log(this.value);
                selectedCategory = this.value;
                lastPage = false;
                currentPage = 1;
                const productGrid = document.querySelector('.product_list_listpage .row');
                productGrid.innerHTML = '';
                fetchProducts(currentPage);
            });
        });

        // Attach the scroll event listener
        window.addEventListener('scroll', handleScroll);
        // Initial fetch of products
        fetchProducts(currentPage);
    });
</script>

@endsection