@section('title')
Book At Door Tag
@endsection
@extends('frontend-layouts.main')
@section('style')
<style>
    .product_image {
        width: 100%;
    }

    .product-short-title {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        /* Limit to 1 line */
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
    }
</style>
@endsection
@section('content')
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--start breadcrumb-->
        <section class="py-3 border-bottom border-top d-none d-md-flex bg-light">
            <div class="container">
                <div class="page-breadcrumb d-flex align-items-center">
                    <!-- <h3 class="breadcrumb-title pe-3">Shop Grid Left Sidebar</h3> -->
                    <div class="ms-auto">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 p-0">
                                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i> Home</a>
                                </li>
                                <li class="breadcrumb-item"><a href="javascript:;">{{$tag->name}}</a>
                                </li>

                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </section>
        <!--end breadcrumb-->
        <!--start shop area-->
        <section class="py-4">
            <div class="container">
                <div class="row">
                    <div class="col-12 col-xl-12">
                        <div class="product-wrapper">
                            <div class="toolbox d-flex align-items-center mb-3 gap-2 border p-3">
                                <div class="d-flex flex-wrap flex-grow-1 gap-1">
                                    <div class="d-flex align-items-center flex-nowrap">
                                        <p class="mb-0 font-13 text-nowrap">Sort By:</p>
                                        <select class="form-select ms-3 rounded-0">
                                            <option value="menu_order" selected="selected">Default sorting</option>
                                            <option value="popularity">Sort by popularity</option>
                                            <option value="date">Sort by newness</option>
                                            <option value="price">Sort by price: low to high</option>
                                            <option value="price-desc">Sort by price: high to low</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                           
                        </div>
                        <div class="product-grid product_list_listpage">
                            <div class="row row-cols-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-4 row-cols-xxl-5 g-3 g-sm-4">
                                <!-- List items -->
                            </div>
                        </div>
                        <hr>
                        <nav class="d-flex justify-content-between" aria-label="Page navigation">
                            <ul class="pagination">
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
            <!--end row-->
    </div>
    </section>
    <!--end shop area-->
</div>
</div>
<!--end page wrapper -->
@endsection
@section('script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let currentPage = 1;
        let isLoading = false;
        let lastPage = false;

        function fetchProducts(page = 1, tag) {
            console.log(tag);
            if (isLoading || lastPage) return;
            isLoading = true;
            axios.get('/product/list', {
                    params: {
                        page: page,
                        tag: tag,
                    }
                })
                .then(function(response) {
                    const products = response.data.data.products.data;
                    const pagination = response.data.data.products;
                    const productGrid = document.querySelector('.product_list_listpage .row');
                    products.forEach(product => {
                        const productCard = `
                            <div class="col">
                                <div class="card">
                                    <div class="position-relative overflow-hidden">
                                        <div class="add-cart position-absolute top-0 end-0 mt-3 me-3">
                                            <a href="javascript:;"><i class='bx bx-cart-add'></i></a>
                                        </div>
                                        <div class="quick-view position-absolute start-0 bottom-0 end-0">
                                            <a href="/${product.slug}">View Details</a>
                                        </div>
                                        <a href="/${product.slug}">
                                        <div class="ImageCard">
                                            <img src="${product.image}" class="img-fluid product_image" alt="${product.name}">
                                             </div>
                                        </a>
                                    </div>
                                    <div class="card-body px-0">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="">
                                                <p class="mb-1 product-short-name">${product.category}</p>
                                                <h6 class="mb-0 fw-bold product-short-title">${product.name}</h6>
                                            </div>
                                        </div>
                                        
                                        <div class="product-price d-flex align-items-center justify-content-start gap-2 mt-2">
                                            ${product.mrp ? `<div class="h6 fw-light fw-bold text-secondary text-decoration-line-through">₹${product.mrp}</div>` : ''}
                                            <div class="h6 fw-bold">₹${product.price}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;

                        productGrid.insertAdjacentHTML('beforeend', productCard);
                    });
                    updatePagination(pagination);
                    isLoading = false;
                })
                .catch(function(error) {
                    console.error('Error fetching products:', error);
                    isLoading = false;
                });
        }

        function updatePagination(pagination) {
            const paginationControls = document.querySelector('.pagination');
            paginationControls.innerHTML = '';

            if (pagination.current_page < pagination.last_page) {
                paginationControls.insertAdjacentHTML('beforeend', `
                    <li class="page-item">
                        <button class="load-more-btn btn btn-primary">Load More</button>
                    </li>
                `);
                const loadMoreBtn = document.querySelector('.load-more-btn');
                loadMoreBtn.addEventListener('click', function() {
                    const nextPage = pagination.current_page + 1;
                    fetchProducts(nextPage, tag);
                });
            } else {
                lastPage = true;
            }
        }

        function handleScroll() {
            const {
                scrollTop,
                scrollHeight,
                clientHeight
            } = document.documentElement;

            if (scrollTop + clientHeight >= scrollHeight - 5 && !isLoading) {
                const loadMoreBtn = document.querySelector('.load-more-btn');
                if (loadMoreBtn) {
                    loadMoreBtn.click(); // Simulate a click on the "Load More" button
                }
            }
        }
        // Attach the scroll event listener
        window.addEventListener('scroll', handleScroll);

        // Initial fetch of products
        var tag = "{{ $tag->slug }}";
        fetchProducts(currentPage, tag);
    });
</script>

@endsection