<?php

use App\Http\Controllers\GoogleSheetController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/fetch-get-sheet',[GoogleSheetController::class,'getFetchSheetData']);

Route::get('/get-sheet',[GoogleSheetController::class,'getSheetData']);

Route::get('/get-categories',[GoogleSheetController::class,'getCategoriesForSheet']);
Route::post('/update-category',[GoogleSheetController::class,'updateItemCategory']);

Route::get('/get-tags',[GoogleSheetController::class,'getTagsForSheet']);
Route::post('/update-tags',[GoogleSheetController::class,'updateItemTags']);

Route::get('/get-author',[GoogleSheetController::class,'getAuthorForSheet']);
Route::post('/update-author',[GoogleSheetController::class,'updateAuthor']);



Route::post('/update-description',[GoogleSheetController::class,'updateItemDescription']);
Route::post('/upload-googlesheet-single-row',[GoogleSheetController::class,'AddDataSheetDataSingleRow']);




Route::post('/update-sheet',[GoogleSheetController::class,'updateSheetData']);
Route::get('/add-sheet',[GoogleSheetController::class,'AddDataSheetData']);

Route::post('/add-sheet-from-web',[GoogleSheetController::class,'AddDataSheetData']);





