<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/404', function () {
    return view('error.404');
});
Route::get('/500', function () {
    return view('error.500');
});
Route::get('/comingsoon', function () {
    return view('error.comingsoon');
});
Route::get('/maintenance', function () {
    return view('error.maintenance');
});

Route::get('/login', 'Auth\LoginController@showLoginForm');
Route::get('/login/admin', 'Auth\LoginController@showAdminLoginForm');
Route::post('/login/admin', 'Auth\LoginController@adminLogin');


Auth::routes();
Route::get('/', function () {
    return view('admin.dashboard');
})->middleware('auth');




// admin routes

Route::group(['middleware' => 'auth:admin'], function () {
    Route::post('/admin/dashboard', 'DashboardController@getAdminDashboardData');
    Route::post('/admin/popup-data', 'DashboardController@popupData');
    Route::post('/admin/count-notification', 'DashboardController@countData');

    Route::get('/admin', function () {
        return view('admin.dashboard');
    });
    Route::post('/admin/get-all-single-location', 'ServiceLocationController@getAllServiceLocations');
    Route::get('/admin/service-locations', function () {
        return view('admin.service-locations.list');
    });
    Route::post('/admin/get-location-list', 'ServiceLocationController@getServiceLocationList');
    Route::post('/admin/create-location', 'ServiceLocationController@createServiceLocation');
    Route::post('/admin/update-location', 'ServiceLocationController@updateServiceLocation');
    Route::post('/admin/delete-location', 'ServiceLocationController@deleteServiceLocation');
    Route::post('/admin/get-single-location', 'ServiceLocationController@getSingleServiceLocation');



    // orders
    Route::get('/admin/orders', function () {
        return view('admin.orders.order-list');
    });
    Route::get('/admin/order-details/{uid}', 'OrderController@orderDetailsAdmin');
    Route::get('/admin/order-details/{uid}/order-details-pdf', 'OrderController@orderDetailsPDF');
    Route::post('/admin/get-admin-orders-list', 'OrderController@getAdminOrdersList');


    Route::post('/admin/status-change', 'OrderController@orderStatusChange');

    // products
    Route::get('/admin/products', function () {
        return view('admin.products.product-list');
    });
    Route::get('/admin/create-product', 'AdminItemController@create');
    Route::post('/admin/create-item', 'AdminItemController@createNewItem');
    Route::post('/admin/get-all-items', 'AdminItemController@getItemList');

    Route::get('/admin/edit-product/{uid}', 'AdminItemController@editProduct');
    Route::post('/admin/update-item', 'AdminItemController@updateProduct');
    Route::post('/admin/delete-item', 'AdminItemController@deleteItem');

    Route::get('/admin/draft-product', function () {
        return view('admin.products.draft-product-list');
    });
    Route::post('/admin/get-draft-product-list', 'AdminItemController@getDraftProductList');

    Route::get('/admin/unverified-product', function () {
        return view('admin.products.unverified-product-list');
    });
    
    Route::post('/admin/get-unverified-product-list', 'AdminItemController@getUnverifiedProductList');
    Route::get('/admin/view-product/{id}', 'AdminItemController@viewProduct');
    Route::post('/admin/view-product/{id}/change-unverified-product-approve-status', 'AdminItemController@updateUnverifiedProductApproveStatus')->name('admin.verify.product');
    
    //Bulk upload
    Route::get('/admin/product-bulk-upload', function () {
        return view('admin.products.bulk-upload');
    });
    Route::post('/admin/bulk-upload', 'BulkUploadController@processBulkUpload')->name('bulkproduct-upload');
    Route::post('/admin/save-bulk-upload', 'BulkUploadController@saveBulkUpload')->name('bulkproduct-upload.save');


    /** upload from sheet */
    Route::get('/admin/google-sheet-product-upload', 'BulkUploadController@getUploadFromSheet');



    //product review
    Route::get('/admin/products/{id}/review', 'AdminItemController@reviewItem');
    Route::post('/admin/get-reviews', 'AdminItemController@getReviewList');
    Route::post('/admin/delete-reviews', 'AdminItemController@delete');
    Route::get('/admin/review/{id}/edit', 'AdminItemController@editReview');
    Route::post('/admin/review/{id}/edit', 'AdminItemController@updateReview')->name('admin.review.update.p');

    //product delivery charges
    Route::get('/admin/products/{id}/delivery-charge', 'AdminItemController@productDeliveryChargeListPage');
    Route::post('/admin/get-product-delivery-charge-list', 'AdminItemController@getProductDeliveryChargeList');
    Route::post('/admin/products/{id}/delivery-charge/add-delivery-charge', 'AdminItemController@addProductDeliveryCharge')->name('admin.product.delivery.charge.create');
    Route::post('/admin/get-single-product-delivery-charge', 'AdminItemController@getProductDeliveryCharge');
    Route::post('/admin/update-product-delivery-charge', 'AdminItemController@updateProductDeliveryCharge');
    Route::post('/admin/delete-product-delivery-charge', 'AdminItemController@deleteProductDeliveryCharge');

    // Gallery
    Route::get('/admin/{id}/gallery-list', 'AdminItemController@list');
    Route::post('/admin/gallery-list', 'AdminItemController@getGalleryList');
    Route::post('/admin/create-admin-gallery-image', 'AdminItemController@createAdminGalleryImage');
    Route::post('/admin/get-gallery-image', 'AdminItemController@getGalleryImage');
    Route::post('/admin/update-gallery-image', 'AdminItemController@updateGalleryImage');
    Route::post('/admin/delete-gallery-image', 'AdminItemController@deleteGalleryImage');


    //variants
    Route::get('/admin/products/{id}/item-variants', 'AdminItemController@getItemVariants');

    // settings
    Route::get('/admin/settings', function () {
        return view('admin.settings.list');
    });
    Route::post('/admin/get-settings-list', 'AdminFolderController@settingsList');
    Route::post('/admin/get-single-setting', 'AdminFolderController@getSetting');
    Route::post('/admin/update-setting', 'AdminFolderController@updateSetting');

    Route::post('/getLocation', 'AdminFolderController@getLocation');
    // pincode
    Route::get('/admin/pincode', 'AdminFolderController@getPincodeIndex');
    Route::post('/admin/create-pincode', 'AdminFolderController@createPincode');
    Route::post('/admin/update-pincode', 'AdminFolderController@updatePincode');
    Route::post('/admin/get-single-pincode', 'AdminFolderController@getSinglePincode');
    Route::post('/admin/get-pincode-list', 'AdminFolderController@getPincodeList');

    // banners
    Route::get('/admin/banner-list', 'BannerController@list');
    Route::post('/admin/get-banner-image-list', 'BannerController@getAdminBannerImageList');
    Route::post('/admin/create-admin-banner-image', 'BannerController@createAdminBannerImage');
    Route::post('/admin/get-banner-image', 'BannerController@getBannerImage');
    Route::post('/admin/update-banner-image', 'BannerController@updateBannerImage');
    Route::post('/admin/delete-banner-image', 'BannerController@deleteBannerImage');

    // category
    Route::get('/admin/categories', 'AdminCategoryController@getCategoryIndex');
    Route::post('/admin/get-category-list', 'AdminCategoryController@getCategoryList');
    Route::post('/admin/get-single-category', 'AdminCategoryController@getSingleCategory');
    Route::post('/admin/get-all-categories', 'AdminCategoryController@getAllCategories');
    Route::get('/admin/create-category', 'AdminCategoryController@create')->name('admin.category.create');
    Route::post('/admin/save-category', 'AdminCategoryController@createCategory')->name('admin.category.create.p');
    Route::get('/admin/category/{id}/edit', 'AdminCategoryController@edit')->name('admin.category.edit');
    Route::post('/admin/category/{id}/update', 'AdminCategoryController@update')->name('admin.category.update.p');
    Route::post('/admin/get-categories', 'AdminCategoryController@getCategories');
    Route::post('/admin/change-home-status', 'AdminCategoryController@homeStatus');


    // Author
    Route::get('/admin/authors', 'AdminAuthorController@getAuthors');
    Route::post('/admin/get-author-list', 'AdminAuthorController@getAuthorList');
    Route::get('/admin/create-author', 'AdminAuthorController@createAuthor')->name('admin.author.create');
    Route::post('/admin/save-author', 'AdminAuthorController@saveAuthor')->name('admin.author.create.p');
    Route::post('/admin/delete-author', 'AdminAuthorController@deleteAuthor');

    Route::post('/admin/get-author-data', 'AdminAuthorController@getAuthorData');
    Route::post('/admin/update-author', 'AdminAuthorController@updateAuthor');







    // product types
    Route::get('/admin/product-types', 'ProductTypeController@getProductIndex');
    Route::post('/admin/get-product-type-list', 'ProductTypeController@getProductList');
    Route::post('/admin/get-single-product-type', 'ProductTypeController@getSingleProduct');
    Route::post('/admin/get-all-product-types', 'ProductTypeController@getAllProductTypes');
    Route::get('/admin/create-product-type', 'ProductTypeController@create')->name('admin.product-type.create');
    Route::post('/admin/save-product-type', 'ProductTypeController@createProduct')->name('admin.product-type.create.p');
    Route::get('/admin/product-type/{id}/edit', 'ProductTypeController@edit')->name('admin.product-type.edit');
    Route::post('/admin/product-type/{id}/update', 'ProductTypeController@update')->name('admin.product-type.update.p');
    Route::post('/admin/get-product-types', 'ProductTypeController@getProductTypes');
    Route::post('/admin/delete-product-type', 'ProductTypeController@delProduct');

    // vendors
    Route::get('/admin/vendor', function () {
        return view('admin.vendor.list');
    });
    Route::get('/admin/create-vendor', 'VendorController@create');
    Route::post('/admin/create-vendor', 'VendorController@createVendor')->name('admin.vendor.create.p');
    Route::post('/admin/get-vendor-list', 'VendorController@getVendorList');
    Route::get('/admin/unapproved-vendor', function () {
        return view('admin.vendor.unapproved-vendor-list');
    });
    Route::post('/admin/get-unapproved-vendor-list', 'VendorController@getUnapprovedVendorList');
    Route::get('/admin/vendor/{id}/edit', 'VendorController@editVendor');
    Route::post('/admin/vendor/{id}/update', 'VendorController@updateVendor')->name('admin.vendor.update.p');
    Route::post('/admin/delete-vendor', 'VendorController@delVendor');
    Route::post('/admin/change-vendor-status', 'VendorController@updateVendorStatus');
    Route::post('/admin/change-vendor-approve-status', 'VendorController@updateVendorApproveStatus');

    Route::post('/getReseller', 'VendorController@getResellerDetails');

    // resellers
    Route::get('/admin/reseller', function () {
        return view('admin.reseller.list');
    });
    Route::get('/admin/create-reseller', 'ResellerController@create');
    Route::post('/admin/create-reseller', 'ResellerController@createReseller')->name('admin.reseller.create.p');
    Route::post('/admin/get-reseller-list', 'ResellerController@getResellerList');
    Route::get('/admin/reseller/{id}/edit', 'ResellerController@editReseller');
    Route::post('/admin/reseller/{id}/update', 'ResellerController@updateReseller')->name('admin.reseller.update.p');
    Route::post('/admin/delete-reseller', 'ResellerController@delReseller');
    Route::post('/admin/change-reseller-status', 'ResellerController@updateResellerStatus');
    Route::post('/admin/change-reseller-approve-status', 'ResellerController@updateResellerApproveStatus');
    Route::get('/admin/reseller/{id}/address-list', 'ResellerController@userAddressList');
    Route::post('/admin/reseller/get-address-list', 'ResellerController@getUserAddressList');

    Route::post('/getVendor', 'ResellerController@getVendorDetails');

    // users
    Route::get('/admin/customers', function () {
        return view('admin.customers.list');
    });
    Route::post('/admin/get-customers-list', 'CustomerController@getUserList');
    Route::get('/admin/customers/{id}/change-password', 'CustomerController@editPassword');
    Route::post('/admin/customers/{id}/changepassword', 'CustomerController@updatePassword')->name('admin.password.update.p');

    // Coupons
    Route::get('/admin/coupon', 'CouponController@getCouponIndex');
    Route::get('/admin/create-coupon', 'CouponController@create');
    Route::post('/admin/save-coupon', 'CouponController@createCoupon')->name('admin.coupon.create.p');
    Route::get('/admin/coupon/{id}/edit', 'CouponController@edit')->name('admin.coupon.edit');
    Route::post('/admin/coupon/{id}/update', 'CouponController@update')->name('admin.coupon.update.p');
    Route::post('/admin/delete-coupon', 'CouponController@delete');
    Route::post('/admin/coupon-list', 'CouponController@getCouponList');
    Route::get('/admin/get-coupon-list/{id}/users', 'CouponController@getCouponUsersList');

    //slider
    Route::get('/admin/slider', 'SliderController@getSliderIndex');
    Route::post('/admin/get-slider-list', 'SliderController@getSliderList');
    Route::post('/admin/get-single-slider', 'SliderController@getSingleSlider');
    Route::get('/admin/create-slider', 'SliderController@create')->name('admin.slider.create');
    Route::post('/admin/save-slider', 'SliderController@createSlider')->name('admin.slider.create.p');
    Route::get('/admin/slider/{id}/edit', 'SliderController@edit')->name('admin.slider.edit');
    Route::post('/admin/slider/{id}/update', 'SliderController@update')->name('admin.slider.update.p');
    Route::post('/admin/delete-slider', 'SliderController@deleteSlider');

    // delivery partners
    Route::get('/admin/delivery-partners', function () {
        return view('admin.delivery-partners.list');
    });
    Route::post('/admin/get-delivery-partners-list', 'DeliveryPartnerController@getDeliveryPartnersList');
    Route::get('/admin/create-delivery-partner', function () {
        return view('admin.delivery-partners.create');
    });
    Route::post('/admin/save-delivery-partner', 'DeliveryPartnerController@saveDeliveryPartner')->name('admin.delivery-partner.save');
    Route::get('/admin/delivery-partners/{id}/edit-delivery-partner', 'DeliveryPartnerController@editDeliveryPartner');
    Route::post('/admin/delivery-partners/{id}/update-delivery-partner', 'DeliveryPartnerController@updateDeliveryPartner')->name('admin.delivery-partner.update');
    Route::post('/admin/delete-delivery-partner', 'DeliveryPartnerController@deleteDeliveryPartner');

    // Push Notification
    Route::get('/admin/push-notification', 'PushNotificationController@getPushNotificationIndex');
    Route::get('/admin/create-push-notification', 'PushNotificationController@create');
    Route::post('/admin/save-push-notification', 'PushNotificationController@createPushNotification')->name('admin.push-notification.create.p');
    Route::get('/admin/push-notification/{id}/edit', 'PushNotificationController@edit')->name('admin.push-notification.edit');
    Route::post('/admin/push-notification/{id}/update', 'PushNotificationController@update')->name('admin.push-notification.update.p');
    Route::get('/admin/push-notification/{id}/view', 'PushNotificationController@viewNotificationUsers');
    Route::post('/admin/push-notification-list', 'PushNotificationController@getPushNotificationList');

    // customers
    Route::get('/admin/contact-us', function () {
        return view('admin.contact-us.list');
    });
    Route::post('/admin/get-contact-us-list', 'ContactController@getUserContactUsList');
    Route::post('/admin/contact-notification', 'ContactController@getContacts');
    Route::post('/admin/contact-us-change-status', 'ContactController@changeStatus');

    //vendor sales report
    Route::get('/admin/sales-report', 'OrderController@salesReport')->name('admin.sales-report');
    Route::get('/admin/sales-report-pdf', 'OrderController@salesReportPDF')->name('admin.sales-report-pdf');

    //reseller sales report
    Route::get('/admin/reseller-sales-report', 'OrderController@resellerSalesReport')->name('admin.reseller-sales-report');
    Route::get('/admin/reseller-sales-report-pdf', 'OrderController@resellerSalesReportPDF')->name('admin.reseller-sales-report-pdf');
});



Route::get('/', 'FrontendController@index')->name('home');
Route::get('/products', 'FrontendController@products');
Route::get('/about', 'FrontendController@about');
Route::get('/contact', 'FrontendController@contact');
Route::get('/blogs', 'FrontendController@blogs');
Route::get('/blog/{id}', 'FrontendController@blogDetails');
Route::get('/product/list', 'FrontendController@getProductList');

Route::get('/category/{slug}', 'FrontendController@getCategoryProductList');
Route::get('/tag/{slug}', 'FrontendController@getTagsProductList');


Route::get('login/google', 'GoogleLogiController@redirectToGoogle');
Route::get('login/google/callback', 'GoogleLogiController@handleGoogleCallback');




Route::get('/product/search', 'FrontendController@getSearch');
Route::get('/meilisearch/update-filterable', 'MeilisearchController@updateFilterableAttributes');





Route::get('/cart', 'FrontendController@getCartList');

Route::get('/user-login', 'FrontendController@getUserLogin')->name('user-login');
Route::post('/user-login', 'FrontendController@setUserLogin')->name('user-login.p');

Route::get('/user-register', 'FrontendController@getUserRegister');
Route::post('/user-register', 'FrontendController@setUserRegister')->name('user-register.p');

Route::get('/user-logout', 'FrontendController@userLogout')->name('user-logout');

Route::group(['middleware' => 'auth:web'], function () {
Route::get('/user-dashboard', 'FrontendController@getUserDashBoard')->name('user-dashboard');
Route::get('/checkout', 'FrontendController@getCheckout')->name('checkout');
Route::get('/checkout-payment', 'FrontendController@getCheckoutPayment')->name('user.checkout-payment');

Route::post('/user/save-address', 'FrontendController@saveUserAddress')->name('save.user.address');





});


Route::get('/{slug}', 'FrontendController@productDetails');

