<?php $__env->startSection('title'); ?>
    Bulk Upload
<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">
        Bulk Upload</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <link href="/assets/plugins/select2/select2.min.css" rel="stylesheet" type="text/css">
    <style>
        .search_border {
            border: 1px solid black;
            padding: 10px;
            margin: 0px -4px !important;
            border-radius: 11px;
            background: #0a1a52;
            color: #fff !important;
        }

        .search_border label {
            color: #fff;
        }

        .search_button_product {
            width: 100%;
        }

        tr.wrong_data {
            background: #9f2d38 !important;
            border: 1px solid red !important;
        }
        .parent_item{
            color: #2b02f6d4;
            font-weight: bold;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('rightbar-action'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('rightbar-content'); ?>
    <!-- Start Contentbar -->
    <div class="contentbar">
        <?php if(session('message')): ?>
            <div class="alert  <?php echo e(session('message-class')); ?>" id="successMessage">
                <?php echo e(session('message')); ?>

            </div>
        <?php endif; ?>
        <!-- Start row -->
        <div class="row">
            <!-- Start col -->
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">


                        <div class="row search_border">

                            <div class="col-md-9">
                                <form id="product_search_form" method="POST" action="<?php echo e(route('bulkproduct-upload')); ?>"
                                    enctype="multipart/form-data">
                                    <?php echo e(csrf_field()); ?>

                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="form-group">
                                                <label> Bulk upload</label>
                                                <div class='input-group'>
                                                    <input type="file" class="form-control" name="product_list"
                                                        id="product_list" accept=".xlsx, .xls, .csv" />

                                                </div>
                                                <div>
                                                    <?php if($errors->has('product_list')): ?>
                                                        <p class="error-tab">
                                                            <strong>*<?php echo e($errors->first('product_list')); ?></strong>
                                                        </p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="col-lg-4">
                                            <div class="form-group" style="text-align:start;">
                                                <button type="submit" style="margin-top: 33px;"
                                                    class="btn btn-sm  btn-secondary search-btn search_button_product">upload
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>


                            </div>

                            <div class="col-md-3">
                                <?php if(isset($products)): ?>
                                    <button type="button" data-id="0"
                                        class="edit-button btn btn-sm btn-warning verify_all"
                                        style="float: none; margin-top: 31px;">Verify All</button>
                                <?php endif; ?>
                            </div>


                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-sm">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>SKU</th>
                                        <th>Photo</th>
                                        <th>Title</th>
                                        <th>Price</th>
                                       
                                        <th>Comments</th>
                                        <th>Actions</th>

                                    </tr>
                                </thead>
                                <tbody id="item-content">
                                    <?php if(isset($products)): ?>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="array_item_<?php echo e($key); ?>">
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($product['sku']); ?> </style></td>
                                                <td><img src="<?php echo e($product['image']); ?>" width="50px" height="50px"
                                                        alt=""></td>
                                                <td><?php echo e($product['title']); ?> </style></td>

                                                <td><?php echo e($product['price']); ?></td>
                                           
                                                <td class="upload_comments"></td>

                                                <td class="cover_action">

                                                    <div class="processing_msg"></div>
                                                    <div class="action_button">
                                                        <div class="btn-group btn-group-sm ">
                                                            <input type="hidden" name="product_data"
                                                                value="<?php echo e(json_encode($product)); ?>">
                                                            <a href="#" data-toggle="tooltip" title=""
                                                                class="tool_tip_cover"
                                                                data-original-title="View Product"><button type="button"
                                                                    data-id="<?php echo e($key); ?>"
                                                                    class="edit-button btn btn-sm btn-warning view_data"
                                                                    style="float: none; margin: 5px;"><span
                                                                        class="ti-eye"></span></button></a>
                                                            <a href="#" data-toggle="tooltip" title=""
                                                                class="tool_tip_cover"
                                                                data-original-title="Edit Product"><button type="button"
                                                                    data-id="<?php echo e($key); ?>"
                                                                    class="edit-button btn btn-sm btn-primary edit_data"
                                                                    style="float: none; margin: 5px;"><span
                                                                        class="ti-pencil"></span></button></a>
                                                            <a href="#" data-toggle="tooltip" title="Verify Product"
                                                                class="tool_tip_cover"><button type="button"
                                                                    data-id="<?php echo e($key); ?>"class="edit-button btn btn-sm btn-success verify_data"
                                                                    style="float: none; margin: 5px;"><span
                                                                        class="ti-check"></span></button></a>
                                                            <button type="button" data-id="<?php echo e($key); ?>"
                                                                class="delete-button btn btn-sm btn-danger tool_tip_cover delete_data"
                                                                style="float: none; margin: 5px;"><span
                                                                    class="ti-trash"></span></button>
                                                        </div>
                                                    </div>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer pagination ml-3">
                    </div>
                </div>
            </div>
            <!-- End col -->
        </div>
        <!-- End row -->
    </div>
    <!-- End Contentbar -->


    <!-- modal -->

    <div class="modal fade" id="view-excel-data" role="dialog">
        <div class="modal-dialog modal-lg">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">View Product</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table  " id="data-table">
                                <thead>
                                    <tr>
                                        <th>Key</th>
                                        <th>Value</th>
                                    </tr>
                                </thead>
                                <tbody id="modal-data-list">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>


    <!-- edit data modal -->
    <div class="modal fade" id="edit-excel-data" role="dialog">
        <div class="modal-dialog modal-lg">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">View Product</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">

                    <div class="card-body">
                        <form action="" id="edit-excel-data" data-row_key="6" method="POST">
                            <div class="table-responsive">
                                <table class="table  " id="data-table">
                                    <thead>
                                        <tr>
                                            <th>Key</th>
                                            <th>Value</th>
                                        </tr>
                                    </thead>
                                    <tbody id="modal-data-edit-list">
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
                </form>
            </div>

        </div>
    </div>

    <!-- modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- Tabledit js -->
    <script src="<?php echo e(asset('assets/js/admin/bulk-item.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin-layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bookatdoor/resources/views/admin/products/bulk-upload.blade.php ENDPATH**/ ?>