<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('assets/frontend/favicon//apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('assets/frontend/favicon//apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/frontend/favicon//apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192" href="<?php echo e(asset('assets/frontend/favicon/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/frontend/favicon/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('assets/frontend/favicon/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/frontend/favicon/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('assets/frontend/favicon/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('assets/frontend/favicon//ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">
    <title> <?php echo $__env->yieldContent('title'); ?> </title>

    <!-- Start CSS -->
    <?php echo $__env->yieldContent('style'); ?>
    <link href="<?php echo e(asset('assets/plugins/switchery/switchery.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="/assets/plugins/animate/animate.css" rel="stylesheet" type="text/css">

    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/flag-icon.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/style.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/datepicker.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/bootstrap-datetimepicker.css')); ?>" rel="stylesheet" type="text/css">




    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link href="<?php echo e(asset('assets/plugins/sweet-alert2/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="/assets/plugins/pnotify/css/pnotify.custom.min.css" rel="stylesheet" type="text/css">
    <style>
        .se-pre-con {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            background: #117A65;
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .spinner-grow {
            color: #ffffff !important;
        }
    </style>
    <!-- <script>
        document.onreadystatechange = function() { 
                if (document.readyState !== "complete") { 
                    setTimeout(function(){ 
                        document.querySelector("body").style.visibility = "hidden"; 
                        document.querySelector(".se-pre-con").style.display = "visible"; 
                    }, 1000);
                } else { 
                    setTimeout(function(){ 
                        document.querySelector(".se-pre-con").style.display = "none"; 
                        document.querySelector("body").style.visibility = "visible"; 
                    }, 1000);
                } 
            }; 
    </script> -->
    <script>
        var notification_popup_flag = true;
    </script>
    <!-- End CSS -->
</head>

<body class="vertical-layout">
    <!-- <div class="se-pre-con">
            <div class="spinner-grow text-primary" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div> -->
    <!-- <body class="horizontal-layout"> -->
    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
    <input type="hidden" id="app-url" value="<?php echo e(URL::to('/')); ?>">

    <!-- Start Infobar Setting Sidebar -->
    <div id="infobar-settings-sidebar" class="infobar-settings-sidebar">
        <div class="infobar-settings-sidebar-head d-flex w-100 justify-content-between">
            <h4>Settings</h4><a href="javascript:void(0)" id="infobar-settings-close" class="infobar-settings-close"><img src="<?php echo e(asset('assets/images/svg-icon/close.svg')); ?>" class="img-fluid menu-hamburger-close" alt="close"></a>
        </div>
        <div class="infobar-settings-sidebar-body">
            <div class="custom-mode-setting">
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">Payment Reminders</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-first" checked /></div>
                </div>
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">Stock Updates</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-second" checked /></div>
                </div>
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">Open for New Products</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-third" /></div>
                </div>
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">Enable SMS</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-fourth" checked /></div>
                </div>
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">Newsletter Subscription</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-fifth" checked /></div>
                </div>
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">Show Map</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-sixth" /></div>
                </div>
                <div class="row align-items-center pb-3">
                    <div class="col-8">
                        <h6 class="mb-0">e-Statement</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-seventh" checked /></div>
                </div>
                <div class="row align-items-center">
                    <div class="col-8">
                        <h6 class="mb-0">Monthly Report</h6>
                    </div>
                    <div class="col-4 text-right"><input type="checkbox" class="js-switch-setting-eightth" checked /></div>
                </div>
            </div>
        </div>
    </div>
    <div class="infobar-settings-sidebar-overlay"></div>
    <!-- End Infobar Setting Sidebar -->
    <!-- Start Containerbar -->
    <!-- class="container-fluid" -->
    <div id="containerbar">
        <!-- Start Rightbar -->
        <?php echo $__env->make('admin-layouts.leftbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin-layouts.rightbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>

        <!-- End Rightbar -->
        <!-- Modal -->
        <div class="modal fade" id="myModal" role="dialog">
            <audio id="xyz" src="<?php echo e(asset('assets/images/notification.mp3')); ?>" preload="auto"></audio>
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 style="color:white;">New Unassigned/Delay Order</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div id="modal1">
                            <p style="display:inline;">A New Unassigned Order Detected.</p>
                            <a style="float:right;" type="button" class="btn btn-success" href="<?php echo e(url('/admin/unassigned-orders')); ?>">Check Order</a>
                        </div>
                        <div style="padding-top: 20px;" id="modal2">
                            <p style="display:inline;">A New Delayed Order Detected.</p>
                            <a style="float:right;" type="button" class="btn btn-success" href="<?php echo e(url('/admin/incomplete-orders')); ?>">Check Order</a>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Modal -->
    </div>
    <!-- End Containerbar -->
    <!-- Start JS -->
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/modernizr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/detect.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.slimscroll.js')); ?>"></script>
    <!-- <script src="<?php echo e(asset('assets/js/horizontal-menu.js')); ?>"></script>  -->
    <script src="<?php echo e(asset('assets/js/vertical-menu.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/switchery/switchery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap-datetimepicker.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker.en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/custom-form-datepicker.js')); ?>"></script>

    <script src="/assets/plugins/bootstrap-inputmask/jquery.inputmask.bundle.min.js"></script>
    <script src="/assets/js/custom/custom-form-inputmask.js"></script>

    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script src="<?php echo e(asset('assets/plugins/sweet-alert2/sweetalert2.min.js')); ?>"></script>

    <script src="/assets/plugins/pnotify/js/pnotify.custom.min.js"></script>

    <script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>

    <?php echo $__env->yieldContent('script'); ?>

    <!-- Core JS -->

    <script src="<?php echo e(asset('assets/js/core.js')); ?>"></script>
    <!-- End JS -->
    <script>
        var $html = $("html");
        var dark_data = localStorage.getItem("theme_dark");
        if (dark_data == "1") {
            $('#toggle-switch').trigger('click');
            $html.addClass("dark-mode");
        }
        // dark mode switch
        $("#toggle-switch").on("change", function() {
            if (this.checked) {
                localStorage.setItem("theme_dark", "1");
                $html.addClass("dark-mode");
            } else {
                localStorage.setItem("theme_dark", "0");
                $html.removeClass("dark-mode");
            }
        });
    </script>
</body>

</html><?php /**PATH /var/www/html/bookatdoor/resources/views/admin-layouts/main.blade.php ENDPATH**/ ?>