<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('meta_data'); ?>
    <?php echo $__env->yieldContent('og_data'); ?>
    <!--favicon-->
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('assets/frontend/favicon/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('assets/frontend/favicon//apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('assets/frontend/favicon//apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/frontend/favicon//apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192" href="<?php echo e(asset('assets/frontend/favicon/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/frontend/favicon/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('assets/frontend/favicon/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/frontend/favicon/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('assets/frontend/favicon/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('assets/frontend/favicon//ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">
    <!--plugins-->
    <link href="<?php echo e(asset('frontend/plugins/OwlCarousel/css/owl.carousel.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('frontend/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <!-- loader-->
    <link href="<?php echo e(asset('frontend/css/pace.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('frontend/js/pace.min.js')); ?>"></script>
    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Albert+Sans:wght@300;400;500;600&display=swap" rel="stylesheet">
    <?php echo $__env->yieldContent('style'); ?>
    <link href="<?php echo e(asset('frontend/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('frontend/css/responsive.css')); ?>" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.2/css/boxicons.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('frontend/css/icons.css')); ?>" rel="stylesheet">
    <!-- FONT AWESOME -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <meta name="description" content="Discover India's No.1 all-in-one online bookstore, Book at Door! Shop a wide range of books including competitive exam guides, novels, and fiction. Fast delivery, excellent prices, and an extensive collection for all readers.">
    <meta name="keywords" content="Book at Door, India's No.1 book store, competitive exam books, buy novels online, fiction books, exam preparation guides, buy books India, online bookstore India, e-commerce books, best novels in India, all-in-one bookstore, book delivery India">
    <title> <?php echo $__env->yieldContent('title'); ?> </title>
    <style>

    </style>
</head>

<body>
    <!--wrapper-->
    <div class="wrapper">
        <!--start top header wrapper-->
        <div class="header-wrapper">
            <div class="top-menu">
                <div class="container">
                    <nav class="navbar navbar-expand">
                        <div class="shiping-title d-none d-sm-flex">Welcome to our Book At Door!</div>
                        <ul class="navbar-nav ms-auto d-none d-lg-flex">
                            <li class="nav-item"><a class="nav-link" href="order-tracking.html">Track Order</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="about-us.html">About</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="shop-categories.html">Our Stores</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="blog-post.html">Blog</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="contact-us.html">Contact</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="javascript:;">Help & FAQs</a>
                            </li>
                        </ul>

                        <ul class="navbar-nav social-link ms-lg-2 ms-auto">
                            <li class="nav-item"> <a class="nav-link" href="javascript:;"><i class='bx bxl-facebook'></i></a>
                            </li>
                            <li class="nav-item"> <a class="nav-link" href="javascript:;"><i class='bx bxl-twitter'></i></a>
                            </li>
                            <li class="nav-item"> <a class="nav-link" href="javascript:;"><i class='bx bxl-linkedin'></i></a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
            <div class="header-content bg-warning">
                <div class="container">
                    <div class="row align-items-center gx-4">
                        <div class="col-auto">
                            <div class="d-flex align-items-center gap-3">
                                <div class="mobile-toggle-menu d-inline d-xl-none NaviNone" data-bs-toggle="offcanvas"
                                    data-bs-target="#offcanvasNavbar">
                                    <i class="bx bx-menu"></i>
                                </div>
                                <!-- logo -->
                                <div class="logo">
                                    <a href="/">
                                        <img src="<?php echo e(asset('frontend/images/logo.svg')); ?>" class="logo-icon" alt="" />
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-12  col-xl order-4 order-xl-0 search">
                            <div class="position-relative">
                                <div class="input-group flex-nowrap pb-3 pb-xl-0">
                                    <input type="text" id="search-input" class="" placeholder="Search for Products">
                                    <button class="btn btn-dark btn-ecomm border-3" type="button" id="search-btn">Search</button>
                                    <!-- <button class="btn btn-dark btn-ecomm border-3 SerarchNone" type="button" id="search-btn"><i class="bx bx-search"></i></button> -->

                                </div>
                                <div id="search-results"></div>
                            </div>
                        </div>
                        <div class="col-auto d-none d-xl-flex">
                            <div class="d-flex align-items-center gap-3">
                                <div class="fs-1 text-content"><i class='bx bx-headphone'></i></div>
                                <div class="">
                                    <p class="mb-0 text-content">CALL US NOW</p>
                                    <h5 class="mb-0"> +91-9562141317</h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-auto ms-auto">
                            <div class="top-cart-icons">
                                <nav class="navbar navbar-expand">
                                    <ul class="navbar-nav">
                                        <li class="nav-item NaviNone"><a href="<?php echo e(url('/user-dashboard')); ?>" class="nav-link cart-link"><i class='bx bx-user'></i></a>
                                            <?php if(Auth::check()): ?>
                                            <span class="logined-user-name">Hi <?php echo e(Auth::user()->name); ?></span>
                                            <?php endif; ?>

                                        </li>

                                        <li class="nav-item dropdown dropdown-large NaviNone">
                                            <a href="<?php echo e(url('/cart')); ?>" class="nav-link position-relative cart-link"> <span class="alert-count cart-count">0</span>
                                                <i class='bx bx-shopping-bag'></i>
                                            </a>

                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    <!--end row-->
                </div>
            </div>
            <div class="primary-menu">
                <nav class="navbar navbar-expand-xl w-100 navbar-dark container mb-0 p-0">
                    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar">
                        <div class="offcanvas-header">
                            <div class="offcanvas-logo"><img src="<?php echo e(asset('frontend/images/logo.svg')); ?>" width="100" alt="">
                            </div>
                            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body primary-menu">
                            <ul class="navbar-nav justify-content-center flex-grow-1 gap-1">
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(url('/')); ?>">Home</a>
                                </li>
                                <li class="nav-item"> <a class="nav-link" href="<?php echo e(url('/products')); ?>">Products</a>
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="tv-shows.html"
                                        data-bs-toggle="dropdown">
                                        Categories
                                    </a>

                                    <?php
                                    $chunkSize = ceil($categories->count() / 2);
                                    $categoryChunks = $categories->chunk($chunkSize);
                                    ?>




                                    <div class="dropdown-menu dropdown-large-menu">
                                        <div class="row">
                                            <div class="col-12 col-xl-4">
                                                <ul class="list-unstyled">
                                                    <?php $__currentLoopData = $categoryChunks[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a href="<?php echo e(url('/category/' . $category->slug)); ?>"><?php echo e($category->name); ?></a></li>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                            <!-- end col-3 -->
                                            <div class="col-12 col-xl-4">
                                                <ul class="list-unstyled">
                                                    <?php if(isset($categoryChunks[1])): ?>
                                                    <?php $__currentLoopData = $categoryChunks[1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a href="<?php echo e(url('/category/' . $category->slug)); ?>"><?php echo e($category->name); ?></a></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                            <!-- end col-3 -->
                                            <div class="col-12 col-xl-4 d-none d-xl-block">
                                                <div class="pramotion-banner1">
                                                    <img src="<?php echo e(asset('frontend/images/gallery/menu-img.jpg')); ?>" class="img-fluid" alt="" />
                                                </div>
                                            </div>
                                            <!-- end col-3 -->
                                        </div>
                                        <!-- end row -->
                                    </div>
                                </li>


                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(url('/about')); ?>">About</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(url('/contact')); ?>">Contact</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(url('/blogs')); ?>">Blog</a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </nav>
            </div>
        </div>

        <div class="BottmNavigation">
            <div class="container">
                <ul>
                    <li><a href="/"><i class="bx bx-home"></i></a></li>
                    <li>
                        <div class="mobile-toggle-menu d-inline d-xl-none" data-bs-toggle="offcanvas"
                            data-bs-target="#offcanvasNavbar">
                            <i class="bx bx-menu"></i>
                        </div>
                    </li>
                    <li class="nav-item"><a href="<?php echo e(url('/user-dashboard')); ?>" class="nav-link cart-link"><i class='bx bx-user'></i></a>
                        <?php if(Auth::check()): ?>
                        <span class="logined-user-name">Hi <?php echo e(Auth::user()->name); ?></span>
                        <?php endif; ?>

                    </li>
                    <li class="nav-item dropdown dropdown-large">
                        <a href="<?php echo e(url('/cart')); ?>" class="nav-link position-relative cart-link"> <span class="alert-count cart-count">0</span>
                            <i class='bx bx-shopping-bag'></i>
                        </a>

                    </li>
                </ul>
            </div>
        </div>
        <!--end top header wrapper-->
        <?php echo $__env->yieldContent('content'); ?>
        <!--start footer section-->
        <footer>
            <section class="py-5 border-top bg-light">
                <div class="container">
                    <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
                        <div class="col">
                            <div class="footer-section1">
                                <h5 class="mb-4 text-uppercase fw-bold">Contact Info</h5>
                                <div class="address mb-3">
                                    <h6 class="mb-0 text-uppercase fw-bold">Address</h6>
                                    <p class="mb-0">Calicut,Kerala</p>
                                </div>
                                <div class="phone mb-3">
                                    <h6 class="mb-0 text-uppercase fw-bold">Phone</h6>
                                    <p class="mb-0">Mobile : +91-9562141317</p>
                                </div>
                                <div class="email mb-3">
                                    <h6 class="mb-0 text-uppercase fw-bold">Email</h6>
                                    <p class="mb-0">info@bookatdoor.com</p>
                                </div>
                                <div class="working-days mb-3">
                                    <h6 class="mb-0 text-uppercase fw-bold">WORKING DAYS</h6>
                                    <p class="mb-0">Mon - SUN / 9:30 AM - 7:30 PM</p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="footer-section2">
                                <h5 class="mb-4 text-uppercase fw-bold">Categories</h5>
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $categories->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="mb-1">
                                        <a href="<?php echo e(url('/category/' . $category->slug)); ?>">
                                            <i class='bx bx-chevron-right'></i> <?php echo e($category->name); ?>

                                        </a>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col">
                            <div class="footer-section3">
                                <h5 class="mb-4 text-uppercase fw-bold">Popular Tags</h5>
                                <div class="tags-box d-flex flex-wrap gap-2">
                                    <?php $__currentLoopData = $global_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(url('/tag/' . $tag->slug)); ?>" class="btn btn-ecomm btn-outline-dark"><?php echo e($tag->name); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="footer-section4">
                                <h5 class="mb-4 text-uppercase fw-bold">Stay informed</h5>
                                <div class="subscribe">
                                    <input type="text" class="form-control" placeholder="Enter Your Email" />
                                    <div class="mt-3 d-grid">
                                        <a href="javascript:;" class="btn btn-dark btn-ecomm">Subscribe</a>
                                    </div>
                                    <p class="mt-3 mb-0">Subscribe to our newsletter to receive early discount offers, updates and new products info.</p>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!--end row-->
                </div>
            </section>

            <section class="footer-strip text-center py-3 border-top positon-absolute bottom-0">
                <div class="container">
                    <div class="d-flex flex-column flex-lg-row align-items-center gap-3 justify-content-between">
                        <p class="mb-0">Copyright © <?= date('Y') ?>. All right reserved.</p>
                        <div class="payment-icon">
                            <div class="row row-cols-auto g-2 justify-content-end">
                                <div class="col">
                                    <img src="<?php echo e(asset('frontend/images/icons/visa.png')); ?>" alt="" />
                                </div>
                                <div class="col">
                                    <img src="<?php echo e(asset('frontend/images/icons/paypal.png')); ?>" alt="" />
                                </div>
                                <div class="col">
                                    <img src="<?php echo e(asset('frontend/images/icons/mastercard.png')); ?>" alt="" />
                                </div>
                                <div class="col">
                                    <img src="<?php echo e(asset('frontend/images/icons/american-express.png')); ?>" alt="" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </footer>
        <!--end footer section-->


        <!--end quick view product-->
        <!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
        <!--End Back To Top Button-->
    </div>
    <!--end wrapper-->

    <!-- Bootstrap JS -->
    <script src="<?php echo e(asset('frontend/js/bootstrap.bundle.min.js')); ?>"></script>
    <!--plugins-->

    <script src="<?php echo e(asset('frontend/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/plugins/OwlCarousel/js/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/plugins/OwlCarousel/js/owl.carousel2.thumbs.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <!--app JS-->
    <script src="<?php echo e(asset('frontend/js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/index.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/product-details.js')); ?>"></script>

    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>
        let timeout = null;
        document.getElementById('search-input').addEventListener('keyup', function() {
            clearTimeout(timeout);
            const query = this.value;
            if (query.length >= 3) {
                timeout = setTimeout(() => {
                    axios.get('/product/search', {
                            params: {
                                query
                            }
                        })
                        .then(response => {
                            const results = response.data.data.search;
                            let resultsHTML = '';

                            if (results.length > 0) {
                                results.forEach(product => {
                                    resultsHTML += `<div> <a href="${product.slug}">${product.name}</a></div>`;
                                });
                            } else {
                                resultsHTML = '<div>No products found</div>';
                            }
                            document.getElementById('search-results').innerHTML = resultsHTML;
                        })
                        .catch(error => {
                            console.error('There was an error fetching the products:', error);
                        });
                }, 300);
            } else {
                document.getElementById('search-results').innerHTML = '';
            }
        });

        document.getElementById('search-btn').addEventListener('click', function() {
            const query = document.getElementById('search-input').value;
            if (query.length >= 3) {
                axios.get('/product/search', {
                        params: {
                            query
                        }
                    })
                    .then(response => {
                        // Display search results
                        const results = response.data.data.search;
                        let resultsHTML = '';

                        if (results.length > 0) {
                            results.forEach(product => {
                                resultsHTML += `<div> <a href="${product.slug}">${product.name}</a></div>`;
                            });
                        } else {
                            resultsHTML = '<div>No products found</div>';
                        }

                        document.getElementById('search-results').innerHTML = resultsHTML;
                    })
                    .catch(error => {
                        console.error('There was an error fetching the products:', error);
                    });
            }
        });
    </script>
    <script src="<?php echo e(asset('frontend/js/cart.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>


</body>

</html><?php /**PATH /var/www/html/bookatdoor/resources/views/frontend-layouts/main.blade.php ENDPATH**/ ?>