<?php $__env->startSection('title'); ?>
Checkout Payment
<?php $__env->stopSection(); ?>


<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>



<div class="page-wrapper">
    <div class="page-content">
        <!--start breadcrumb-->
        <section class="py-3 border-bottom border-top d-none d-md-flex bg-light">
            <div class="container">
                <div class="page-breadcrumb d-flex align-items-center">
                    <h3 class="breadcrumb-title pe-3">Checkout</h3>
                    <div class="ms-auto">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 p-0">
                                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i> Home</a>
                                </li>
                                <li class="breadcrumb-item"><a href="javascript:;">Shop</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Checkout</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </section>
        <!--end breadcrumb-->
        <!--start shop cart-->
        <section class="py-4">
            <div class="container">
                <div class="shop-cart">
                    <div class="row">
                        <div class="col-12 col-xl-8">
                            <div class="checkout-payment">
                                <div class="card bg-transparent rounded-0 shadow-none">
                                    <div class="card-body">


                                        <div class="steps steps-light">
                                            <a class="step-item active" href="<?php echo e(url('/cart')); ?>">
                                                <div class="step-progress"><span class="step-count">1</span>
                                                </div>
                                                <div class="step-label"><i class='bx bx-cart'></i>Cart</div>
                                            </a>
                                            <a class="step-item active " href="<?php echo e(url('/checkout')); ?>">
                                                <div class="step-progress"><span class="step-count">2</span>
                                                </div>
                                                <div class="step-label"><i class='bx bx-user-circle'></i>Details</div>
                                            </a>

                                            <a class="step-item active current" href="<?php echo e(url('/checkout-payment')); ?>">
                                                <div class="step-progress"><span class="step-count">3</span>
                                                </div>
                                                <div class="step-label"><i class='bx bx-credit-card'></i>Payment</div>
                                            </a>

                                        </div>
                                    </div>
                                </div>
                                <form id="paymentForm">
                                    <div class="card rounded-0 shadow-none border">
                                        <div class="card-header border-bottom">
                                            <h2 class="h5 my-2">Choose Payment Method</h2>
                                        </div>
                                        <div class="card-body PaymentCards row">
                                            <div class="Flex">
                                            <input type="radio" id="cod" name="payment_option" value="cod">
                                            <label for="cod">COD (Cash on Delivery)</label>
                                            <img src="<?php echo e(asset('frontend/images/payment/cos.svg')); ?>" class="logo-icon" alt="" />
                                            </div>
                                            <div class="Flex">
                                            <input type="radio" id="credit_card" name="payment_option" value="credit_card">
                                            <label for="credit_card">Credit Card</label>
                                            <img src="<?php echo e(asset('frontend/images/payment/creditcard.svg')); ?>" class="logo-icon" alt="" />
                                            </div>
                                            <div class="Flex">
                                            <input type="radio" id="debit_card" name="payment_option" value="debit_card">
                                            <label for="debit_card">Debit Card</label>
                                            <img src="<?php echo e(asset('frontend/images/payment/debitcard.svg')); ?>" class="logo-icon" alt="" />
                                            </div>
                                            <div class="Flex">
                                            <input type="radio" id="phone_pay" name="payment_option" value="phone_pay">
                                            <label for="phone_pay">Phone Pay</label>
                                            <img src="<?php echo e(asset('frontend/images/payment/phonepay.svg')); ?>" class="logo-icon" alt="" />
                                            </div>
                                            

                                            

                                           






                                        </div>
                                    </div>
                                    <div class="card rounded-0 shadow-none border">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="d-grid">
                                                        <a href="<?php echo e(url('/checkout')); ?>" class="btn btn-light btn-ecomm"><i class="bx bx-chevron-left"></i>Back to Shipping</a>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-grid">
                                                        <button class="btn btn-outline-dark btn-ecomm">Place Order Now<i class="bx bx-chevron-right"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </form>
                            </div>
                        </div>
                        <div class="col-12 col-xl-4">
                            <div class="order-summary">
                                <div class="card rounded-0">
                                    <div class="card-body">

                                        <div class="card rounded-0 border bg-transparent shadow-none">
                                            <div class="card-body" id="checkout_item_products">
                                                <p class="fs-5">Order summary</p>


                                            </div>
                                        </div>
                                        <div class="card rounded-0 border bg-transparent mb-0 shadow-none">
                                            <div class="card-body">
                                                <p class="mb-2">Subtotal: <span class="float-end">₹ <span class="sub_total_cart"></span></span>
                                                </p>
                                                <p class="mb-2">Shipping: <span class="float-end">₹<span class="cart_shipping_charge"></span>
                                                </p>

                                                <p class="mb-0">Discount: <span class="float-end">₹<span class="cart_discount_charge"></span>
                                                </p>
                                                <div class="my-3 border-top"></div>
                                                <h5 class="mb-0">Order Total: <span class="float-end"> ₹<span class="cart_grand_total"></span></span></h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end row-->
                </div>
            </div>
        </section>
        <!--end shop cart-->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        renderCheckoutItems();
    });


    $(document).ready(function() {

        $('#paymentForm').on('submit', function(e) {
            e.preventDefault();
            var paymentOption = $('input[name="payment_option"]:checked').val();
            var cardNumber = $('#card_number').val();
            $.ajax({
                url: '/submit-payment',
                method: 'POST',
                data: {
                    payment_option: paymentOption,
                    card_number: paymentOption === 'credit_card' || paymentOption === 'debit_card' ? cardNumber : null
                },
                success: function(response) {
                    $('#response').html('<p>Payment option submitted successfully!</p>');
                },
                error: function(xhr, status, error) {
                    $('#response').html('<p>There was an error submitting your payment option.</p>');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend-layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bookatdoor/resources/views/frontend/checkout-payment.blade.php ENDPATH**/ ?>