<?php $__env->startSection('title'); ?>
Google sheet list
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<!-- Select2 CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/css/select2.min.css">
<style>
    .table td {
        color: #8A98AC;
        vertical-align: middle;
        border-top: 1px solid rgba(0, 0, 0, 0.03);
        padding: 0.6rem;
        white-space: normal;
        word-wrap: break-word;
        overflow-wrap: break-word;
        max-width: 300px;
        font-size: 0.875rem;
        line-height: 1.5;
        background-color: #ffffff;
        text-align: left;
        transition: background-color 0.2s ease-in-out;
    }

    .table td:hover {
        background-color: #f9f9f9;
    }

    .table th {
        color: #333333;
        font-weight: bold;
        background-color: #f5f5f5;
        border-bottom: 2px solid rgba(0, 0, 0, 0.05);
        padding: 0.7rem;
        text-align: left;
    }
</style>
<link href="/assets/css/image-uploader.css" rel="stylesheet" type="text/css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('rightbar-action'); ?>






<?php $__env->stopSection(); ?>


<?php $__env->startSection('rightbar-content'); ?>
<!-- Start Contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">


            <div class="card m-b-30">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">Google sheet</h5>
                        </div>
                        <div class="col-6">
                            <ul class="list-inline-group text-right mb-0 pl-0">
                                <li class="list-inline-item">
                                    <div class="form-group mb-0 amount-spent-select">

                                    </div>
                                </li>
                            </ul>
                        </div>

                        <div class="col-6">
                            <div class="row">
                                <div class="col-6">

                                    <div id="sheet_download_status" style="display: none; font-weight: bold; margin-top: 10px;">
                                        Please wait, file is downloading...
                                    </div>
                                    <button class="btn btn-success sheet_download_btn">
                                        <i class="feather icon-plus mr-1"></i>Download from sheet
                                    </button>

                                </div>
                                <div class="col-6">

                                    <div id="upload-status" style="display: none; font-weight: bold; margin-top: 10px;">
                                        Please wait, file is uploading...
                                    </div>
                                    <button class="btn btn-success update_sheet_btn">
                                        <i class="feather icon-plus mr-1"></i>Update to sheet
                                    </button>
                                </div>
                            </div>



                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Sku</th>
                                            <th>Title</th>
                                            <th>Description</th>
                                            <th>Mrp</th>
                                            <th>Price</th>
                                            <th>Category</th>
                                            <th>Tags</th>
                                            <th>Author</th>
                                            <th>Image</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody id="sheet_content">
                                        <?php $__currentLoopData = $sheets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(($sheets->currentPage() - 1) * $sheets->perPage() + $index + 1); ?></td>
                                            <td><?php echo e($sheet['sku']); ?></td>
                                            <td><?php echo e($sheet['title']); ?></td>
                                            <!-- <td><?php echo e($sheet['description']); ?> <span><a href="#" class="description_add" data-index="<?php echo e($sheet['id']); ?>"><i class="fa fa-plus-circle"></i></a></span></td> -->
                                            <td>
                                                <?php
                                                $truncatedDescription = Str::limit($sheet['description'], 50, '...');
                                                ?>

                                                <span

                                                    title="<?php echo e($sheet['description']); ?>"
                                                    data-bs-placement="top">
                                                    <?php echo e($truncatedDescription); ?>

                                                </span>
                                                <span>
                                                    <a href="#" class="description_add" data-index="<?php echo e($sheet['id']); ?>" data-description="<?php echo e($sheet['description']); ?>">
                                                        <i class="fa fa-plus-circle"></i>
                                                    </a>
                                                </span>
                                            </td>

                                            <td><?php echo e($sheet['mrp']); ?></td>
                                            <td><?php echo e($sheet['price']); ?></td>
                                            <td>
                                                <?php

                                                $categoryNames = [];
                                                $categoryIds = explode(',', $sheet['category']);
                                                foreach ($categoryIds as $id) {
                                                $category = $categories->firstWhere('id', $id);
                                                if ($category) {
                                                $categoryNames[] = $category->name;
                                                }
                                                }
                                                ?>
                                                <?php echo e(implode(', ', $categoryNames)); ?>

                                                <span><a href="#" class="category _add" data-index="<?php echo e($sheet['id']); ?>"><i class="fa fa-plus-circle"></i></a></span>
                                            </td>
                                            <td>
                                                <?php
                                                $tagNames = [];
                                                $tagIds = explode(',', $sheet['tags']);
                                                foreach ($tagIds as $id) {
                                                $tag = $tags->firstWhere('id', $id);
                                                if ($tag) {
                                                $tagNames[] = $tag->name;
                                                }
                                                }
                                                ?>
                                                <?php echo e(implode(', ', $tagNames)); ?>

                                                <span><a href="#" class="tag _add" data-index="<?php echo e($sheet['id']); ?>"><i class="fa fa-plus-circle"></i></a></span>
                                            </td>
                                            <td>
                                                <?php
                                                $author = $authors->firstWhere('id', $sheet['author']);
                                                ?>
                                                <?php echo e($author ? $author->name : '-'); ?>

                                                <span><a href="#" class="author _add" data-index="<?php echo e($sheet['id']); ?>"><i class="fa fa-plus-circle"></i></a></span>
                                            </td>

                                            <td>
                                                <?php if($sheet['image']): ?>
                                                <a href="<?php echo e($sheet['image']); ?>" target="_blank" class="text-decoration-none">
                                                    <i class="fa fa-camera fa-lg text-primary"></i>
                                                </a>
                                                <br>
                                                <?php $__currentLoopData = ['gallery1', 'gallery2', 'gallery3', 'gallery4']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($sheet[$gallery])): ?>
                                                <a href="<?php echo e($sheet[$gallery]); ?>" target="_blank" class="text-decoration-none mx-1">
                                                    <i class="fa fa-image fa-lg text-primary"></i>
                                                </a>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <!-- Upload Button with FontAwesome Icon -->
                                                <button class="btn-upload" data-index="<?php echo e($sheet['id']); ?>">
                                                    <i class="fa fa-upload"></i> Upload
                                                </button>
                                                <!-- Success Icon, initially hidden -->
                                                <span class="success-icon" style="display:none;">
                                                    <i class="fa fa-check-circle" style="color:green;"></i> Success
                                                </span>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                <div class="pagination">
                                    <?php echo e($sheets->links()); ?>

                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="card-footer pagination ml-3">
                    </div>
                </div>
            </div>
            <!-- End col -->

        </div>
        <!-- End row -->
    </div>


    <!-- Modal Structure -->
    <div class="modal fade" id="categoryModal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryModalLabel">Add Categories</h5>
                    <button type="button" class="btn-close close_modal" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="categoryForm">
                        <div class="mb-3">
                            <label for="categories" class="form-label">Select Categories</label>
                            <select id="categories" class="form-control" name="categories[]" multiple="multiple" style="width: 100%;">
                            </select>
                        </div>
                        <input type="hidden" id="rowIndex" name="rowIndex" value="">
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary close_modal" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="saveCategory">Save</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Structure for Tags -->
    <div class="modal fade" id="tagModal" tabindex="-1" aria-labelledby="tagModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="tagModalLabel">Add Tags</h5>
                    <button type="button" class="btn-close close_modal" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="tagForm">
                        <div class="mb-3">
                            <label for="tags" class="form-label">Select Tags</label>
                            <select id="tags" class="form-control" name="tags[]" multiple="multiple" style="width: 100%;">
                            </select>
                        </div>
                        <input type="hidden" id="rowIndex" name="rowIndex" value="">
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary close_modal" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="saveTag">Save</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Structure for Author -->
    <div class="modal fade" id="authorModal" tabindex="-1" aria-labelledby="authorModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="authorModalLabel">Select Author</h5>
                    <button type="button" class="btn-close close_modal" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="authorForm">
                        <div class="mb-3">
                            <label for="authors" class="form-label">Select Author</label>
                            <select id="authors" class="form-control" name="author" style="width: 100%;">
                                <!-- Authors will be populated here -->
                            </select>
                        </div>
                        <input type="hidden" id="rowIndex" name="rowIndex" value="">
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary close_modal" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="saveAuthor">Save</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Template -->
    <div class="modal fade" id="descriptionModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Description</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="descriptionForm">
                        <div class="form-group">
                            <label for="descriptionInput">Description</label>
                            <textarea class="form-control" id="descriptionInput" rows="4"></textarea>
                        </div>
                        <input type="hidden" id="descriptionId">
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary save-description">Save</button>
                </div>
            </div>
        </div>
    </div>





    <!-- End Contentbar -->
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('script'); ?>
    <!-- Select2 JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#categories').select2({
                placeholder: "Select categories",
                allowClear: true
            });

            $('.category._add').on('click', function(e) {
                e.preventDefault();

                const rowIndex = $(this).data('index');
                $('#rowIndex').val(rowIndex);

                $.ajax({
                    url: '/api/get-categories',
                    method: 'GET',
                    success: function(response) {
                        if (response.success && response.data && response.data.categories) {
                            const categories = response.data.categories;
                            $('#categories').empty();
                            categories.forEach(function(category) {
                                $('#categories').append(
                                    `<option value="${category.id}">${category.name}</option>`
                                );
                            });
                            $('#categories').trigger('change');
                        } else {
                            alert('Failed to fetch categories.');
                        }
                    },
                    error: function() {
                        alert('An error occurred while loading categories.');
                    }
                });

                $('#categoryModal').modal('show');
            });

            $('#saveCategory').on('click', function() {
                const selectedCategories = $('#categories').val();
                const rowIndex = $('#rowIndex').val();

                if (selectedCategories.length > 0) {
                    const selectedNames = $('#categories option:selected').map(function() {
                        return $(this).text();
                    }).get();
                    const categoryCell = $('tr').eq(rowIndex).find('td').eq(5);
                    categoryCell.html(selectedNames.join(', '));
                }

                $('#categoryModal').modal('hide');
            });
        });


        $('#saveCategory').on('click', function() {
            const selectedCategories = $('#categories').val();
            const rowIndex = $('#rowIndex').val();
            if (selectedCategories.length > 0) {
                const selectedNames = $('#categories option:selected').map(function() {
                    return $(this).text();
                }).get();
                $.ajax({
                    url: '/api/update-category',
                    method: 'POST',
                    data: {
                        id: rowIndex,
                        categories: selectedCategories,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            location.reload();
                        } else {
                            alert('Failed to update category.');
                        }
                    },
                    error: function() {
                        alert('An error occurred while updating the category.');
                    }
                });
            }
        });


        $(document).ready(function() {
            $(document).on('click', '.close_modal', function() {
                $('#categoryModal').modal('hide'); // Close the modal
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#tags').select2({
                placeholder: "Select tags",
                allowClear: true
            });

            $('.tag._add').on('click', function(e) {
                e.preventDefault();

                const rowIndex = $(this).data('index');
                $('#rowIndex').val(rowIndex);

                $.ajax({
                    url: '/api/get-tags', // Fetch tags from the server
                    method: 'GET',
                    success: function(response) {
                        if (response.success && response.data && response.data.tags) {
                            const tags = response.data.tags;
                            $('#tags').empty();
                            tags.forEach(function(tag) {
                                $('#tags').append(
                                    `<option value="${tag.id}">${tag.name}</option>`
                                );
                            });
                            $('#tags').trigger('change');
                        } else {
                            alert('Failed to fetch tags.');
                        }
                    },
                    error: function() {
                        alert('An error occurred while loading tags.');
                    }
                });

                $('#tagModal').modal('show');
            });

            $('#saveTag').on('click', function() {
                const selectedTags = $('#tags').val();
                const rowIndex = $('#rowIndex').val();

                if (selectedTags.length > 0) {
                    const selectedNames = $('#tags option:selected').map(function() {
                        return $(this).text();
                    }).get();
                    const tagCell = $('tr').eq(rowIndex).find('td').eq(6);
                }

                $.ajax({
                    url: '/api/update-tags',
                    method: 'POST',
                    data: {
                        id: rowIndex,
                        tags: selectedTags,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            location.reload();
                        } else {
                            alert('Failed to update tags.');
                        }
                        $('#tagModal').modal('hide');
                    },
                    error: function() {
                        alert('An error occurred while updating the tags.');
                    }
                });
            });

            $(document).on('click', '.close_modal', function() {
                $('#tagModal').modal('hide');
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#authors').select2({
                placeholder: "Select an author",
                allowClear: true
            });

            $('.author._add').on('click', function(e) {
                e.preventDefault();

                const rowIndex = $(this).data('index');
                $('#rowIndex').val(rowIndex);


                $.ajax({
                    url: '/api/get-author',
                    method: 'GET',
                    success: function(response) {
                        if (response.success && response.data && response.data.authors) {
                            const authors = response.data.authors;
                            $('#authors').empty();
                            authors.forEach(function(author) {
                                $('#authors').append(
                                    `<option value="${author.id}">${author.name}</option>`
                                );
                            });
                            $('#authors').trigger('change');
                        } else {
                            alert('Failed to fetch authors.');
                        }
                    },
                    error: function() {
                        alert('An error occurred while loading authors.');
                    }
                });
                $('#authorModal').modal('show');
            });


            $('#saveAuthor').on('click', function() {
                const selectedAuthor = $('#authors').val();
                const rowIndex = $('#rowIndex').val();

                if (selectedAuthor) {
                    const authorName = $('#authors option:selected').text();
                    const authorCell = $('tr').eq(rowIndex).find('td').eq(7);
                    authorCell.html(authorName);
                    $.ajax({
                        url: '/api/update-author',
                        method: 'POST',
                        data: {
                            id: rowIndex,
                            author: selectedAuthor,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                location.reload();
                            } else {
                                alert('Failed to update author.');
                            }
                            $('#authorModal').modal('hide');
                        },
                        error: function() {
                            alert('An error occurred while updating the author.');
                        }
                    });
                }
            });
            $(document).on('click', '.close_modal', function() {
                $('#authorModal').modal('hide');
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.update_sheet_btn').on('click', function() {
                let uploadStatus = $('#upload-status');
                uploadStatus.show().text('Please wait, file is uploading...');

                const url = '/api/add-sheet-from-web';
                let formData = new FormData();

                $.ajax({
                    url: url,
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        alert('Upload successful!');
                        uploadStatus.text('').hide();
                    },
                    error: function(xhr, status, error) {
                        alert('Upload failed: ' + xhr.responseText);
                        uploadStatus.text('').hide();
                        location.reload();
                    }
                });
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.sheet_download_btn').on('click', function() {
                let uploadStatus = $('#sheet_download_status');
                uploadStatus.show().text('Please wait, file is downloading...');

                const url = '/api/fetch-get-sheet';
                let formData = new FormData();

                $.ajax({
                    url: url,
                    type: 'GET',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        alert('Downloaded successful!');
                        uploadStatus.text('').hide();
                        location.reload();
                    },
                    error: function(xhr, status, error) {
                        alert('Upload failed: ' + xhr.responseText);
                        uploadStatus.text('').hide();
                    }
                });
            });
        });
    </script>


    <script>
        $(document).ready(function() {

            $('.description_add').on('click', function(e) {
                e.preventDefault();
                const rowId = $(this).data('index');
                const currentDescription = $(this).data('description');
                $('#descriptionId').val(rowId);
                $('#descriptionInput').val(currentDescription);
                $('#descriptionModal').modal('show');
            });


            $('.save-description').on('click', function() {
                const id = $('#descriptionId').val();
                const description = $('#descriptionInput').val();


                $.ajax({
                    url: '/api/update-description',
                    method: 'POST',
                    data: {
                        id: id,
                        description: description,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            location.reload();
                        } else {
                            alert('Failed to update author.');
                        }
                        $('#authorModal').modal('hide');
                    },
                    error: function() {
                        alert('An error occurred while updating the author.');
                    }
                });


            });

            // Function to reattach click event for dynamically added elements
            function bindDescriptionClick() {
                $('.description._add').off('click').on('click', function(e) {
                    e.preventDefault();

                    const rowId = $(this).data('index');
                    const currentDescription = $(this).closest('td').text().trim();

                    $('#descriptionId').val(rowId);
                    $('#descriptionInput').val(currentDescription);
                    $('#descriptionModal').modal('show');
                });
            }
        });
    </script>

    <script>
        $(document).on('click', '.btn-upload', function() {
            var sheetId = $(this).data('index');
            var buttonElement = $(this);
            buttonElement.prop('disabled', true);
            $.ajax({
                url: '/api/upload-googlesheet-single-row',
                method: 'POST',
                data: {
                    id: sheetId,
                    _token: '<?php echo e(csrf_token()); ?>'
                },

                success: function(response) {
                    buttonElement.closest('td').find('.success-icon').show();
                    buttonElement.hide();
                },
                error: function(xhr, status, error) {
                    alert('An error occurred! Please try again.');
                    buttonElement.prop('disabled', false);
                }


            });
        });
    </script>


    <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin-layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bookatdoor/resources/views/admin/products/google-sheet-upload.blade.php ENDPATH**/ ?>