<?php $__env->startSection('title'); ?>
<?php echo e($item->name); ?> || Book At Door
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_data'); ?>
<!-- Meta Tags -->
<meta name="description" content="<?php echo e($item->description); ?>">
<meta name="keywords" content="">
<meta name="author" content="Book At Door">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('og_data'); ?>
<!-- Open Graph Tags -->
<meta property="og:title" content="<?php echo e($item->name); ?>">
<meta property="og:description" content="<?php echo e($item->description); ?>">
<meta property="og:image" content="<?php echo e($item->image); ?>">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:type" content="website">

<!-- Twitter Card Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($item->name); ?>">
<meta name="twitter:description" content="<?php echo e($item->description); ?>">
<meta name="twitter:image" content="<?php echo e($item->image); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('style'); ?>
<style>
    .product_image {
        width: 100%;
    }

    .product-short-title {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        /* Limit to 1 line */
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .color-indigator-item {
        display: inline-block;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        /* This makes the color indicator round */
        border: 2px solid transparent;
        /* Initial transparent border */
        cursor: pointer;
        margin: 5px;
        transition: border-color 0.3s ease;
    }

    .color-indigator-item.selected-color {
        border: 2px solid #000;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
    }

    .color-indigator-item:hover {
        border-color: #ccc;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--start breadcrumb-->
        <section class="py-3 border-bottom border-top d-none d-md-flex bg-light">
            <div class="container">
                <div class="page-breadcrumb d-flex align-items-center">
                    <h3 class="breadcrumb-title pe-3"><?php echo e($item->name); ?></h3>
                    <div class="ms-auto">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 p-0">
                                <li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i> Home</a>
                                </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </section>
        <!--end breadcrumb-->
        <!--start product detail-->
        <section class="py-4">
            <div class="container">
                <div class="product-detail-card">
                    <div class="product-detail-body">
                        <div class="row g-0">
                            <div class="col-12 col-lg-5">
                                <div class="image-zoom-section">

                                    <div class="product-gallery owl-carousel owl-theme p-3" data-slider-id="1">
                                        <div class="item">
                                            <img id="main-product-image" src="<?php echo e($item->image); ?>" class="img-fluid" alt="Main Product Image">
                                        </div>


                                        <?php $__currentLoopData = $item->item_image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="item">
                                            <img src="<?php echo e($gallery->image); ?>" class="img-fluid" alt="Gallery Image">
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>


                                    <div class="owl-thumbs owl-thumbs_gallery_thump d-flex justify-content-center" data-slider-id="1">

                                        <button class="owl-thumb-item">
                                            <img id="main-product-thumb" src="<?php echo e($item->image); ?>" class="img-thumbnail" alt="Main Thumbnail">
                                        </button>


                                        <?php $__currentLoopData = $item->item_image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <button class="owl-thumb-item">
                                            <img src="<?php echo e($gallery->image); ?>" class="img-thumbnail" alt="Thumbnail">
                                        </button>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>

                            </div>
                            <div class="col-12 col-lg-7">
                                <div class="product-info-section p-3">
                                    <h3 class="mt-3 mt-lg-0 mb-0"><?php echo e($item->name); ?></h3>
                                   
                                    <div class="d-flex align-items-center mt-3 gap-2">
                                        <h5 class="mrp_price mb-0 text-decoration-line-through text-light-3">₹<?php echo e($item->mrp); ?></h5>
                                        <h4 class=" sales_cost mb-0">₹<?php echo e($item->price); ?></h4>
                                    </div>
                                    <div class="mt-3">
                                        <h6>Discription :</h6>
                                        <p class="mb-0"><?php echo e($item->descriptions); ?>.</p>
                                    </div>
                                    <dl class="row mt-3">
                                        <dt class="col-sm-3">Product id</dt>
                                        <dd class="col-sm-9 item_sku">#<?php echo e($item->sku); ?></dd>

                                    </dl>
                                    <?php echo $item->features; ?>

                                    <div class="row row-cols-auto align-items-center mt-3">
                                        <div class="col">
                                            <label class="form-label">Quantity</label>
                                            <select class="form-select form-select-sm">
                                                <option>1</option>
                                                <option>2</option>
                                                <option>3</option>
                                                <option>4</option>
                                                <option>5</option>
                                            </select>
                                        </div>
                                        <?php if($variants->reject(function($variant) {return is_null($variant->size);})->unique('size')->count() > 0): ?>
                                        <div class="col">
                                            <label class="form-label">Size</label>
                                            <select class="form-select form-select-sm" id="variant-size">
                                                <?php $__currentLoopData = $variants->unique('size'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($variant->size); ?>" <?php if($variant->size==$item->size): ?> selected <?php endif; ?>><?php echo e($variant->size); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php endif; ?>

                                        <?php if($variants->reject(function($variant) {return is_null($variant->color);})->unique('color')->count() > 0): ?>

                                        <div class="col">
                                            <label class="form-label">Colors</label>
                                            <div class="color-indigators d-flex align-items-center gap-2">
                                                <?php $__currentLoopData = $variants->unique('color'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="color-indigator-item"
                                                    style="background-color: <?php echo e($variant->color); ?>; width: 30px; height: 30px; cursor: pointer;"
                                                    data-color="<?php echo e($variant->color); ?>">
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <!--end row-->
                                    <div class="d-flex gap-2 mt-3">
                                        <a href="javascript:;" class="btn btn-dark btn-ecomm" id="add-to-cart" data-variant-id="<?php echo e($item->id); ?>">
                                            <i class="bx bxs-cart-add"></i>Add to Cart
                                        </a>
                                        <div id="toast-message" class="toast-message">
                                            <h5><i class="fa-solid fa-check"></i> Item added to cart!</h5>
                                        </div>
                                    </div>
                                    <hr />
                                    <div class="product-sharing">
                                        <div class="d-flex align-items-center gap-2 flex-wrap">
                                            <div class="">
                                                <button type="button" class="btn-social bg-twitter"><i class='bx bxl-twitter'></i></button>
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn-social bg-facebook"><i class='bx bxl-facebook'></i></button>
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn-social bg-linkedin"><i class='bx bxl-linkedin'></i></button>
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn-social bg-youtube"><i class='bx bxl-youtube'></i></button>
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn-social bg-pinterest"><i class='bx bxl-pinterest'></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--end row-->
                    </div>
                </div>
            </div>
        </section>
        <!--end product detail-->
        <!--start product more info-->
        <section class="py-4">
            <div class="container">
                <div class="product-more-info">
                    <ul class="nav nav-tabs mb-0" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#discription">
                                <div class="d-flex align-items-center">
                                    <div class="tab-title text-uppercase fw-500">Description</div>
                                </div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#more-info">
                                <div class="d-flex align-items-center">
                                    <div class="tab-title text-uppercase fw-500">More Info</div>
                                </div>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#tags">
                                <div class="d-flex align-items-center">
                                    <div class="tab-title text-uppercase fw-500">Tags</div>
                                </div>
                            </a>
                        </li>

                    </ul>
                    <div class="tab-content pt-3">
                        <div class="tab-pane fade show active" id="discription">
                            <p><?php echo e($item->specification); ?></p>
                        </div>
                        <div class="tab-pane fade" id="more-info">
                            <p>Food truck fixie locavore, accusamus mcsweeney's marfa nulla single-origin coffee squid. Exercitation +1 labore velit, blog sartorial PBR leggings next level wes anderson artisan four loko farm-to-table craft beer twee. Qui photo booth letterpress, commodo enim craft beer mlkshk aliquip jean shorts ullamco ad vinyl cillum PBR. Homo nostrud organic, assumenda labore aesthetic magna delectus mollit. Keytar helvetica VHS salvia yr, vero magna velit sapiente labore stumptown. Vegan fanny pack odio cillum wes anderson 8-bit, sustainable jean shorts beard ut DIY ethical culpa terry richardson biodiesel. Art party scenester stumptown, tumblr butcher vero sint qui sapiente accusamus tattooed echo park.</p>
                        </div>
                        <div class="tab-pane fade" id="tags">
                            <div class="tags-box d-flex flex-wrap gap-2">
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Cloths</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Electronis</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Furniture</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Sports</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Men Wear</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Women Wear</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Laptops</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Formal Shirts</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Topwear</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Headphones</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Bottom Wear</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Bags</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Sofa</a>
                                <a href="javascript:;" class="btn btn-ecomm btn-outline-dark">Shoes</a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <!--end product more info-->
        <!--start similar products-->
        <section class="py-4">
            <div class="container">
                <div class="separator pb-4">
                    <div class="line"></div>
                    <h5 class="mb-0 fw-bold separator-title">Similar Products</h5>
                    <div class="line"></div>
                </div>
                <div class="product-grid">
                    <div class="similar-products owl-carousel owl-theme position-relative">
                        <?php $__currentLoopData = $similar_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $similar_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <div class="card">
                                <div class="position-relative overflow-hidden">
                                    <div class="add-cart position-absolute top-0 end-0 mt-3 me-3">
                                        <a href="<?php echo e(url('/'.$similar_item->slug)); ?>"><i class='bx bx-cart-add'></i></a>
                                    </div>
                                    <div class="quick-view position-absolute start-0 bottom-0 end-0">
                                        <a href="<?php echo e(url('/'.$similar_item->slug)); ?>">Quick View</a>
                                    </div>
                                    <a href="<?php echo e(url('/'.$similar_item->slug)); ?>">
                                        <img src="<?php echo e($similar_item->image); ?>" class="img-fluid" alt="...">
                                    </a>
                                </div>
                                <div class="card-body px-0">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="">
                                            <p class="mb-1 product-short-name">Topwear</p>
                                            <h6 class="mb-0 fw-bold product-short-title"><?php echo e($similar_item->name); ?></h6>
                                        </div>
                                       
                                    </div>
                                  
                                    <div class="product-price d-flex align-items-center justify-content-start gap-2 mt-2">
                                        <div class="h6 fw-light fw-bold text-secondary text-decoration-line-through">₹<?php echo e($item->mrp); ?></div>
                                        <div class="h6 fw-bold">₹<?php echo e($item->price); ?></div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>
        </section>
        <!--end similar products-->
    </div>
</div>
<!--end page wrapper -->



<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        $('#add-to-cart').on('click', function() {
            console.log("Add to Cart clicked!"); // Debugging message

            var $toast = $('#toast-message');

            // Show the toast
            $toast.fadeIn(300).css("display", "block").addClass('show'); // Fade in effect

            // Hide the toast after 3 seconds
            setTimeout(function() {
                $toast.fadeOut(300, function() {
                    $toast.removeClass('show').css("display", "none"); // Fade out effect
                });
            }, 3000);
        });
    });
</script>
<script>
    $(document).ready(function() {
        let variants = <?= json_encode($variants) ?>;


        function filterVariants() {
            let selectedSize = $('#variant-size').val();
            let selectedColor = $('.color-indigator-item.selected-color').data('color');
            let selectedVariant = variants.find(variant => {
                let match = true;
                if (selectedSize) match = match && variant.size === selectedSize;
                if (selectedColor) match = match && variant.color === selectedColor;
                return match;
            });
            if (selectedVariant) {
                $('h4.sales_cost').text('₹' + selectedVariant.price);
                $('h5.mrp_price').text('₹' + selectedVariant.mrp);
                $('.item_sku').text('#' + selectedVariant.sku);
                updateGallery(selectedVariant);
                updateAddToCart(selectedVariant.id);
            }
        }

        function updateColorsForSelectedSize() {
            let selectedSize = $('#variant-size').val();
            let availableColors = variants.filter(variant => variant.size === selectedSize);
            let uniqueColors = [...new Set(availableColors.map(variant => variant.color))];
            $('.color-indigators').empty();
            uniqueColors.forEach(function(color, index) {
                $('.color-indigators').append(`
            <div class="color-indigator-item" 
                style="background-color: ${color}; width: 30px; height: 30px; cursor: pointer;" 
                data-color="${color}">
            </div>
        `);
            });
            $('.color-indigator-item:first').addClass('selected-color');
            filterVariants();
        }
        if ($('#variant-size option').length > 0) {
            $('#variant-size').val($('#variant-size option:first').val());
            updateColorsForSelectedSize();
        }
        $('#variant-size').on('change', function() {
            updateColorsForSelectedSize();
        });
        $(document).on('click', '.color-indigator-item', function() {
            $('.color-indigator-item').removeClass('selected-color');
            $(this).addClass('selected-color');
            filterVariants();
        });

        function updateGallery(selectedVariant) {
            $('.product-gallery').trigger('destroy.owl.carousel').removeClass('owl-carousel owl-loaded');
            $('.product-gallery').find('.owl-stage-outer').children().unwrap();
            $('.product-gallery').empty();
            $('.owl-thumbs_gallery_thump').empty();
            $('.product-gallery').append(`<div class="item"><img id="main-product-image" src="${selectedVariant.image}" class="img-fluid" alt="Main Product Image"></div>`);
            $('.owl-thumbs_gallery_thump').append(`<button class="owl-thumb-item"><img id="main-product-thumb" src="${selectedVariant.image}" class="img-thumbnail" alt="Thumbnail"></button>`);

            selectedVariant.item_image.forEach(function(galleryImage) {
                $('.product-gallery').append(`<div class="item"><img src="${galleryImage.image}" class="img-fluid" alt="Gallery Image"></div>`);
                $('.owl-thumbs_gallery_thump').append(` <button class="owl-thumb-item"><img src="${galleryImage.image}" class="img-thumbnail" alt="Thumbnail"></button>`);
            });

            $('.product-gallery').addClass('owl-carousel owl-theme').owlCarousel({
                items: 1,
            });


        }

        function updateAddToCart(variantId) {
            $('#add-to-cart').attr('data-variant-id', variantId);
        }

        $('#add-to-cart').on('click', function() {
            let selectedVariantId = $(this).attr('data-variant-id');
            addToCart(selectedVariantId, variants);
        });




    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend-layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bookatdoor/resources/views/frontend/product_details.blade.php ENDPATH**/ ?>